% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{calculate_nb_mult}
\alias{calculate_nb_mult}
\title{Calculate NMB and NHB.}
\usage{
calculate_nb_mult(df, outcomes, costs, wtp)
}
\arguments{
\item{df}{a dataframe.}

\item{outcomes}{character. Vector of variable names containing the outcomes to be plotted on the x-axis. The variable names should be structured as follows: 't_qaly_d_' followed by the name of the strategy: e.g. 't_qaly_d_intervention'.}

\item{costs}{character. Vector of variable names containing the costs to be plotted on the y-axis. The variable names should be structured as follows: 't_costs_d_' followed by the name of the strategy: e.g. 't_costs_d_intervention'.}

\item{wtp}{numeric. Willingness-to-pay thresholds to use for NMB and NHB calculations.}
}
\value{
A dataframe containing the original data and the following variables containing the NMB and NHB for each strategy.
The name of these new variables are structured as 'NMB_strategyname' and 'NHB_strategyname'
}
\description{
This function calculates the Net Monetary Benefits (NMB) and Net Health Benefits (NHB) for each strategy and the incremental NMB and NHB.
}
\examples{
# Calculate NB's at a willingness-to-pay threshold of 80000 per unit of effects
data("df_pa")
df_pa$t_costs_d_comp2 <- df_pa$t_costs_d_comp * 1.09
df_pa$t_qaly_d_comp2 <- df_pa$t_qaly_d_comp * 1.01
calculate_nb_mult(df = df_pa,
                  outcomes = c("t_qaly_d_comp2", "t_qaly_d_int", "t_qaly_d_comp"),
                  costs = c("t_costs_d_int", "t_costs_d_comp2", "t_costs_d_comp"),
                  wtp = 50000
                  )
}
