% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-inclusions.R
\name{join_inclusions}
\alias{join_inclusions}
\title{Join kept inclusion events.}
\usage{
join_inclusions(
  diabetes_diagnoses,
  podiatrist_services,
  gld_hba1c_after_drop_steps
)
}
\arguments{
\item{diabetes_diagnoses}{Output from \code{\link[=keep_diabetes_diagnoses]{keep_diabetes_diagnoses()}}.}

\item{podiatrist_services}{Output from \code{\link[=keep_podiatrist_services]{keep_podiatrist_services()}}.}

\item{gld_hba1c_after_drop_steps}{Output from \code{\link[=drop_pregnancies]{drop_pregnancies()}} and
\code{\link[=drop_pcos]{drop_pcos()}}.}
}
\value{
The same type as the input data, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}},
with the joined columns from the output of \code{\link[=keep_diabetes_diagnoses]{keep_diabetes_diagnoses()}},
\code{\link[=keep_podiatrist_services]{keep_podiatrist_services()}}, \code{\link[=drop_pcos]{drop_pcos()}}, and
\code{\link[=drop_pregnancies]{drop_pregnancies()}}. There will be 1-8 rows per \code{pnr}.
}
\description{
This function joins the outputs from all the filtering
functions, by \code{pnr} and \code{dates}. Input datasets:
\itemize{
\item \code{diabetes_diagnoses}: Dates are the first and second hospital
diabetes diagnosis.
\item \code{podiatrist_services}: Dates are the first and second
diabetes-specific podiatrist record.
\item \code{gld_hba1c_after_drop_steps}: Dates are the first and second elevated HbA1c
test results (after excluding results potentially influenced by gestational diabetes), and the
first and second purchase of a glucose-lowering drug (after excluding
purchases potentially related to polycystic ovary syndrome or gestational diabetes).
}
}
\seealso{
See the \code{vignette("algorithm")} for the logic used to filter these
patients.
}
\keyword{internal}
