% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{find_and_filter_patients}
\alias{find_and_filter_patients}
\title{Find and filter patients using predicate functions}
\usage{
find_and_filter_patients(
  client,
  patient_filter = NULL,
  study_filter = NULL,
  series_filter = NULL,
  instance_filter = NULL,
  progress = rlang::is_interactive()
)
}
\arguments{
\item{client}{Orthanc client.}

\item{patient_filter}{Predicate function to filter \link{Patient}s.}

\item{study_filter}{Predicate function to filter \link{Study}s.}

\item{series_filter}{Predicate function to filer \link{Series}.}

\item{instance_filter}{Predicate function to filter \link{Instance}s.}

\item{progress}{Whether to show progress bars. By default, progress bars are
enabled in interactive sessions (i.e., if \code{rlang::is_interactive()}
returns \code{TRUE}).}
}
\value{
A \code{list} of filtered \link{Patient}s.
}
\description{
Find desired Patient/Study/Series/Instance in an Orthanc server. Predicate
functions (filters) take a single Patient/Study/Series/Instance as the
first argument and return a single \code{TRUE} or \code{FALSE} for whether the
resource should be kept or discarded, respectively. If \code{\link[mirai:daemons]{mirai::daemons()}}
has been used to set persistent background processes, this function will
apply filters in parallel using all available processes.
}
\details{
This function builds a series of tree structures. Each tree corresponds to a
patient. The layers in the tree correspond to:

\code{Patient -> Studies -> Series -> Instances}
}
\examples{
client <- Orthanc$new("https://orthanc.uclouvain.be/demo")

find_and_filter_patients(
  client = client,
  patient_filter = \(pt) pt$is_stable
)
}
