% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_medallion_drivers_active.R
\name{nyc_medallion_drivers_active}
\alias{nyc_medallion_drivers_active}
\title{Medallion Drivers - Active}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Transportation/Medallion-Drivers-Active/jb3k-j3gp/about_data>
}
\usage{
nyc_medallion_drivers_active(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Medallion Drivers - Active data.
}
\description{
Downloads Medallion Drivers - Active data from NYC Open Data.
}
\details{
This is a list of drivers with a current TLC Driver License, which authorizes drivers to operate NYC TLC licensed yellow and green taxicabs and for-hire vehicles (FHVs).
This list is accurate as of the date and time shown in the Last Date Updated and Last Time Updated fields.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_medallion_drivers_active(limit = 10)
head(small_sample)

\donttest{
nyc_medallion_drivers_active(limit = 5000)
nyc_medallion_drivers_active(filters = list(type = "MEDALLION TAXI DRIVER"))
}
}
