% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_dob_job_applications.R
\name{nyc_dob_job_applications}
\alias{nyc_dob_job_applications}
\title{NYC DOB Job Application Filings}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/ic3t-wcy2>
}
\usage{
nyc_dob_job_applications(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing DOB Job Application Filings data.
}
\description{
Downloads DOB Job Application Filings data from NYC Open Data.
}
\details{
This dataset includes job application filings submitted to the NYC Department
of Buildings (DOB). Each record represents a construction or alteration
project application, including location, work type, and approval status.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_dob_job_applications(limit = 10)
head(small_sample)

\donttest{
nyc_dob_job_applications(limit = 10)
}
}
