% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_lambdaz.R
\name{find_best_lambdaz}
\alias{find_best_lambdaz}
\title{Find the best terminal elimination rate constant (lambdaz)}
\usage{
find_best_lambdaz(
  time,
  conc,
  route = "bolus",
  duration = NULL,
  adj_r_squared_threshold = 0.7,
  nlastpoints = 3,
  tolerance = 1e-04
)
}
\arguments{
\item{time}{Numeric vector of observation time points.}

\item{conc}{Numeric vector of concentration measurements corresponding to time points.}

\item{route}{Administration method specification:
\itemize{
\item "bolus" (default) - Excludes time of maximum concentration (Tmax) point
\item "infusion" - Includes Tmax point in terminal phase evaluation
\item "oral" - Starts regression from Tmax point
}}

\item{duration}{Numeric (optional). Duration of infusion administration, in the same
time units as \code{time}. Required only when \code{route = "infusion"}. Used to determine
the first post-infusion observation time for terminal phase regression.}

\item{adj_r_squared_threshold}{Minimum acceptable adjusted R-squared value for valid
estimation (default = 0.7). Values below this threshold will generate warnings.}

\item{nlastpoints}{Integer. Minimum number of terminal points (from the end of the profile)
to include when evaluating candidate regression segments for \eqn{\lambda_z}. Default is \code{3}.}

\item{tolerance}{Threshold for considering adjusted R-squared values statistically
equivalent (default = 1e-4). Used when selecting between fits with similar goodness-of-fit.}
}
\value{
A list containing:
\itemize{
\item \code{lambdaz}: Estimated terminal elimination rate constant (\eqn{\lambda_z}), or NA if no valid fit
\item \code{UsedPoints}: Number of data points used in the optimal fit
\item \code{adj.r.squared}: Adjusted R-squared value (\eqn{R^2}) of the optimal regression
\item \code{message}: Character vector containing diagnostic messages or warnings
}
}
\description{
Identifies the optimal terminal phase for lambdaz estimation using a systematic
log-linear regression approach with adjusted R-squared optimization criteria.
}
\details{
The algorithm implements the following decision logic:
\enumerate{
\item Identifies the time of maximum observed concentration (Tmax)
\item Defines candidate terminal phases starting from the last 3 measurable concentrations
\item Iteratively evaluates longer time spans by including preceding data points
\item For each candidate phase:
\itemize{
\item Performs log-concentration vs. time linear regression
\item Requires negative regression slope (positive \eqn{\lambda_z})
\item Calculates adjusted R-squared metric
}
\item Selects the optimal phase based on:
\itemize{
\item Highest adjusted R-squared value
\item When R-squared differences are < tolerance, selects the fit with more points
}
\item Validates final selection against R-squared threshold
}
}
\examples{
# Basic usage
time <- c(0.5, 1, 2, 4, 6, 8, 10)
conc <- c(12, 8, 5, 3, 2, 1.5, 1)
find_best_lambdaz(time, conc)

# With infusion route specification
find_best_lambdaz(time, conc, route = "bolus",duration=1)

# Custom threshold settings
find_best_lambdaz(time, conc, adj_r_squared_threshold = 0.8, tolerance = 0.001)

}
\author{
Zhonghui Huang
}
