% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_single_point_base.R
\name{calculate_cl}
\alias{calculate_cl}
\title{Calculate clearance using an adaptive single-point method}
\usage{
calculate_cl(
  dat,
  half_life = NULL,
  dose_type = NULL,
  pooled_ctrl = pooled_control(),
  ssctrl = ss_control()
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data.
Required columns typically include ID, TIME, DV, tad, recent_ii,
dose, routeobs, and durationobs.}

\item{half_life}{Optional numeric value for the drug's half-life.
If not provided, half-life is estimated using \code{get_hf()} from pooled observations.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Required when half_life is not provided. Classified as
first_dose, repeated_doses, or combined_doses based on whether observed
concentrations occur following the first administration, during repeated
dosing, or across both contexts.}

\item{pooled_ctrl}{Optional list of control parameters used by \code{get_pooled_data()}
for pooling observations. Defaults to output from \code{pooled_control()}.}

\item{ssctrl}{A list of control parameters generated by
\code{ss_control()} to guide the detection of steady-state observations.}
}
\value{
A list containing:
\itemize{
\item dat: the processed dataset with steady-state identification
\item cl_df: individual clearance estimates
\item trimmed_mean_cl: the population clearance calculated as a trimmed
geometric mean with a 5 percent trimming level to reduce the impact
of outliers
}
}
\description{
Calculates clearance using an adaptive single-point pharmacokinetic method
}
\details{
Estimates individual and population clearance from steady-state
pharmacokinetic data. If half-life is not provided, it is estimated
from pooled data using \code{get_hf()} and pooling rules defined in
\code{pooled_control()}.

The procedure:
\itemize{
\item Identifies steady-state observations using \code{is_ss()} and
\code{ss_control()} criteria.
\item Selects peak and trough concentrations within each dose
interval to represent steady-state behavior.
\item Classifies concentration points as Cssmax, Cssmin, or
Cssavg based on timing within the interval and decay pattern.
\item Computes individual clearance as Dose / (Cssavg × tau).
\item Aggregates individual clearance values using a trimmed
geometric mean to obtain a population estimate.
}

Supports bolus, infusion, and oral administration routes.
}
\examples{
dat <- processData(Bolus_1CPT)$dat
calculate_cl(dat, get_hf(dat)$half_life_median)$trimmed_mean_cl

}
\seealso{
\code{\link{get_hf}}, \code{\link{get_pooled_data}},
\code{\link{pooled_control}}, \code{\link{is_ss}}, \code{\link{ss_control}},
\code{\link{trimmed_geom_mean}}
}
\author{
Zhonghui Huang
}
