% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.operator.R
\name{ga.operator}
\alias{ga.operator}
\title{Genetic algorithm operator for model selection}
\usage{
ga.operator(
  dat,
  param_table = NULL,
  search.space = c("ivbase", "oralbase"),
  no.cores = NULL,
  ga.control = gaControl(),
  penalty.control = penaltyControl(),
  precomputed_results_file = NULL,
  foldername = NULL,
  filename = "test",
  seed = 1234,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase". Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{ga.control}{A list of GA control parameters, generated by
\code{gaControl()}. Includes:
\itemize{
\item npop - number of individuals (chromosomes) per generation.
\item niter - maximum number of generations.
\item pcross - crossover probability.
\item pmut - per-bit mutation probability.
\item diff_tol - significance difference threshold used for ranking.
\item nls - frequency (in generations) of running local exhaustive search
around the best current model.
}}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{foldername}{Character string specifying the folder name for storing
intermediate results. If \code{NULL} (default), \code{tempdir()}
is used for temporary storage. If specified, a cache directory
is created in the current working directory.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{seed}{Integer. Random seed controlling the random sampling steps of the
genetic algorithm operator for reproducible runs. Default is 1234.}

\item{.modEnv}{Optional environment used to store run state and cached results.
If NULL, a new environment is created.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to \code{mod.run()}.}
}
\value{
An object of class "gaOperatorResult" containing:
\itemize{
\item Final Selected Code: data frame with the best binary encoding.
\item Final Selected Model Name: model identifier for the best encoding.
\item Model Run History: data frame of fitted models and fitness values.
\item Selection History: list of per-generation results.
}
}
\description{
Run a genetic algorithm to search for an optimal PK model structure within a
predefined search space using nlmixr2-based model fitting and penalties.
}
\details{
The algorithm evolves a population of binary-encoded candidate models over
multiple generations using tournament selection, crossover, mutation, and local
search. Candidate encodings are validated and then evaluated by fitting models
and applying user-defined penalties. The best individual is carried forward to
the next generation.
}
\examples{
\donttest{
# Example usage with phenotype dataset
outs <- ga.operator(
  dat = pheno_sd,
  param_table = NULL,
  search.space = "ivbase",
  ga.control = gaControl(),
  saem.control = nlmixr2est::saemControl(
    seed = 1234,
    nBurn = 200,
    nEm   = 300,
    logLik = TRUE
  )
)
print(outs)
}

}
\seealso{
\link{mod.run}, \link{gaControl}, \link{penaltyControl}, \link{auto_param_table},
\link{spaceConfig}, \link{create.pop}, \link{validStringbinary},
\link{decodeBinary}, \link{parseName}, \link{rank_new}, \link{runlocal},
\link{ga.sel.tournament}, \link{ga.crossover}, \link{ga.mutation}
}
\author{
Zhonghui Huang
}
