% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network.R
\name{get_DM}
\alias{get_DM}
\title{Navigate Downstream Mainstem}
\usage{
get_DM(network, comid, distance = NULL, sort = FALSE, include = TRUE)
}
\arguments{
\item{network}{data.frame NHDPlus flowlines including at a minimum:
COMID, LENGTHKM, DnHydroseq, and Hydroseq.}

\item{comid}{integer identifier to start navigating from.}

\item{distance}{numeric distance in km to limit how many COMIDs are
returned. The COMID that exceeds the distance specified is returned.}

\item{sort}{if TRUE, the returned COMID vector will be sorted in order of distance from the input COMID (nearest to farthest)}

\item{include}{if TRUE, the input COMID will be included in the returned COMID vector}
}
\value{
integer vector of all COMIDs downstream of the starting COMID
along the mainstem
}
\description{
Traverse NHDPlus network downstream main stem
}
\examples{
library(sf)

source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

plot(sample_flines$geom)
start_COMID <- 11690092
DM_COMIDs <- get_DM(sample_flines, start_COMID)
plot(dplyr::filter(sample_flines, COMID \%in\% DM_COMIDs)$geom,
     col = "red", add = TRUE, lwd = 3)

DM_COMIDs <- get_DM(sample_flines, start_COMID, distance = 40)
plot(dplyr::filter(sample_flines, COMID \%in\% DM_COMIDs)$geom,
     col = "blue", add = TRUE, lwd = 2)

}
