% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-overlay.R
\name{plot_overlay}
\alias{plot_overlay}
\title{Composite an overlay map on a structural background}
\usage{
plot_overlay(
  bgvol,
  overlay,
  zlevels = NULL,
  along = 3L,
  bg_cmap = "grays",
  ov_cmap = "inferno",
  bg_range = c("robust", "data"),
  ov_range = c("robust", "data"),
  probs = c(0.02, 0.98),
  ov_thresh = 0,
  ov_alpha = 0.7,
  ncol = 3L,
  title = NULL,
  subtitle = NULL,
  caption = NULL
)
}
\arguments{
\item{bgvol}{Background 3D volume.}

\item{overlay}{Overlay 3D volume (same dims as bgvol).}

\item{zlevels}{Slices to plot (indices along the z/3rd axis by default).}

\item{along}{Axis for slicing (1 sagittal, 2 coronal, 3 axial).}

\item{bg_cmap}{Background palette (e.g., "grays").}

\item{ov_cmap}{Overlay palette (e.g., "inferno").}

\item{bg_range, ov_range}{"robust" or "data" for background/overlay scaling.}

\item{probs}{Quantiles for robust scaling.}

\item{ov_thresh}{Numeric threshold; values with |v| < thresh become transparent.}

\item{ov_alpha}{Global alpha for overlay (0..1).}

\item{ncol}{Number of columns in the facet layout.}

\item{title, subtitle, caption}{Optional labels.}
}
\description{
Works without extra packages by colorizing both layers to rasters and stacking
them as grobs. Great for statistical maps over T1/T2 backgrounds.
}
