% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_collunit.R
\name{set_collunit}
\alias{set_collunit}
\title{set Site Information for Fossil Sites}
\usage{
set_collunit(
  x = NA,
  collectionunitid = NA_integer_,
  notes = NA_character_,
  handle = NA_character_,
  colldate = as.Date(character(1)),
  location = NA_character_,
  waterdepth = NA_integer_,
  gpslocation = st_as_sf(st_sfc()),
  collunittype = NA_character_,
  collectiondevice = NA_character_,
  collectionunitname = NA_character_,
  depositionalenvironment = NA_character_,
  datasets = NULL,
  chronologies = NULL,
  defaultchronology = NA_integer_,
  speleothems = NULL
)
}
\arguments{
\item{x}{object to be set as collunit}

\item{collectionunitid}{collection unit identifier}

\item{notes}{notes}

\item{handle}{handle}

\item{colldate}{collection date}

\item{location}{location of the collection unit}

\item{waterdepth}{depth at where the sample is taken}

\item{gpslocation}{location with GPS}

\item{collunittype}{type of collection unit}

\item{collectiondevice}{device used to collect the sample}

\item{collectionunitname}{name of the collection unit}

\item{depositionalenvironment}{depositional environment}

\item{datasets}{datasets that the collection unit has}

\item{chronologies}{chronologies taken from the collection unit}

\item{defaultchronology}{best chronology model identifier to
be used with this collection unit}

\item{speleothems}{speleothems associated with the collection unit}
}
\value{
\code{collunit} object
}
\description{
Function to create new collection unit objects for
personal analysis.
The new object will not be uploaded to the database.
}
\examples{
{
# Create a collunit
my_collunit <- set_collunit(notes = "my lake")
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}

Simon Goring \email{goring@wisc.edu}
}
