% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publications.R
\name{get_publications}
\alias{get_publications}
\alias{get_publications.default}
\alias{get_publications.numeric}
\alias{get_publications.publication}
\alias{get_publications.publications}
\title{Get publication information for Neotoma records}
\usage{
get_publications(x, ...)

\method{get_publications}{default}(...)

\method{get_publications}{numeric}(x, ...)

\method{get_publications}{publication}(x, ...)

\method{get_publications}{publications}(x, ...)
}
\arguments{
\item{x}{integer A contact ID}

\item{...}{\code{publicationid}
The unique numeric identifier associated with a publication in Neotoma.
\code{datasetid}
A unique identifier for a Neotoma dataset that is associated
with a publication.
\code{familyname} The full or partial last name for an individual author.
\code{pubtype} The publication type, from \code{get_tables("publicationtypes")}.
\code{year} The year the publication was released.
\code{search} A plain text search string used to search the citation.}
}
\value{
\code{publications} object
}
\description{
Uses the Neotoma API to search and access information
about publications associated with data in the Neotoma Paleoecology Database
}
\examples{
\donttest{
# How old are the papers in Neotoma that include the term "mammut"?
tryCatch({
  mammoth_papers <- get_publications(search="mammut") \%>\%
    as.data.frame()
  hist(as.numeric(mammoth_papers$year))
}, error = function(e) {
 message("Neotoma server not responding. Try again later.")
})
# We want the paper identified in Neotoma as 666:
tryCatch({
get_publications(666)
}, error = function(e) {
message("Neotoma server not responding. Try again later.")
})
# Take a publication object and purposely degrade the metadata:
tryCatch({
  bad_pub <- get_publications(666)
  # Note this only changes the reported year, not the citation string.
  bad_pub[[1]]@year <- "1923"
  bad_pub[[1]]@publicationid <- NA_integer_
  updated_pubs <- get_publications(bad_pub[[1]])
  attr(updated_pubs, "matches")
  # we see the proper citation in the record:
  updated_pubs <- attr(updated_pubs, "matches")[[3]]
}, error = function(e) {
 message("Neotoma server not responding. Try again later.")
})
}
}
