test_that("Deprecation warnings work for nday", {
  today <- Sys.Date()
  expect_warning(nday(today, reference_alias = TRUE), "deprecated")
  suppressWarnings({
    expect_match(nday(today, reference_alias = TRUE), "Today")
  })
})

test_that("Deprecation warnings work for ndate", {
  d <- as.Date("2023-01-01")
  expect_warning(ndate(d, display_weekday = FALSE), "deprecated")
  suppressWarnings({
    expect_match(ndate(d, display_weekday = FALSE), "Jan 01, 2023")
  })
})

test_that("Deprecation warnings work for ntimestamp", {
  ts <- as.POSIXct("2023-01-01 12:00:00")
  expect_warning(ntimestamp(ts, include_seconds = FALSE), "deprecated")
  suppressWarnings({
    # Check that it actually worked (no seconds shown)
    res <- ntimestamp(ts, include_seconds = FALSE)
    expect_false(grepl("00S", res))
  })
})

test_that("Deprecation warnings work for npercent", {
  expect_warning(npercent(0.25, is_decimal = TRUE), "deprecated")
  suppressWarnings({
    expect_equal(npercent(0.25, is_decimal = TRUE), "+25.0%")
  })
})

test_that("Deprecation warnings work for nstring", {
  expect_warning(nstring(string = " hello "), "deprecated")
  suppressWarnings({
    expect_equal(nstring(string = " hello "), "hello")
  })
  expect_warning(nstring("a", whitelist_specials = "_"), "deprecated")
  expect_warning(nstring("a", en_only = TRUE), "deprecated")
})
