% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_series}
\alias{load_series}
\title{Load NASCAR Series Data}
\usage{
load_series(series = c("cup", "nxs", "truck"), refresh = FALSE)
}
\arguments{
\item{series}{Character. The series to load. One of \code{"cup"},
\code{"nxs"}, or \code{"truck"}.}

\item{refresh}{Logical. If \code{TRUE}, bypass the in-memory cache
and re-download from cloud storage. Default is \code{FALSE}.}
}
\value{
A data frame with 21 columns of race results:
Season, Race, Track, Name, Length, Surface, Finish, Start,
Car, Driver, Team, Make, Pts, Laps, Led, Status, S1, S2,
S3, Rating, and Win.
}
\description{
Downloads NASCAR series data from Cloudflare R2 as a parquet
file. Data is cached in memory for the current R session so
repeated calls are instant. Each new R session downloads
fresh data, ensuring you always have the latest results.
}
\details{
\subsection{Why "nxs"?}{

NASCAR's NXS uses the sponsor-neutral identifier \code{"nxs"}
rather than a sponsor name. The series has been sponsored by
Busch (1984-2007), Nationwide (2008-2014), Xfinity
(2015-2025), and O'Reilly Auto Parts (2026-present). Using
\code{"nxs"} keeps the identifier stable across sponsor changes.
}

\subsection{Caching}{

Data is cached in memory for the current R session. Repeated
calls return instantly without re-downloading. Starting a new
R session always fetches the latest data from R2.

Use \code{refresh = TRUE} to force a re-download within a session,
or \code{\link[=clear_cache]{clear_cache()}} to reset the in-memory cache.
}
}
\examples{
\donttest{
# Load Cup Series data (downloads on first call, cached after)
cup <- load_series("cup")

# Load NXS data
nxs <- load_series("nxs")

# Load Truck Series data
truck <- load_series("truck")

# Force re-download from cloud storage
cup <- load_series("cup", refresh = TRUE)
}

}
\seealso{
\link{series_data} for column descriptions,
\code{\link[=clear_cache]{clear_cache()}} for cache management,
\code{\link[=get_driver_info]{get_driver_info()}} for driver statistics.
}
