% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_catalog.R
\name{search_catalog}
\alias{search_catalog}
\title{Search Catalogs}
\usage{
search_catalog(
  catalog,
  keyword = NULL,
  from = NULL,
  to = NULL,
  country = NULL,
  inc_iso = NULL,
  collection = NULL,
  created = NULL,
  dtype = NULL,
  sort_by = NULL,
  sort_order = NULL,
  ps = NULL,
  page = NULL,
  rows = TRUE
)
}
\arguments{
\item{catalog}{A required character string specifying the name of the data
catalog (e.g., \code{"fao"}, \code{"wb"}). Valid codes can be found in the
documentation for \code{access_codes()}.}

\item{keyword}{A character string used to search data titles, descriptions,
and keywords (e.g., \code{"lsms"}).}

\item{from}{An integer indicating the \strong{start year} for the data collection's
coverage period (e.g., \code{2000}).}

\item{to}{An integer indicating the \strong{end year} for the data collection's
coverage period (e.g., \code{2010}).}

\item{country}{A character vector. Provide one or more \strong{country names} or
\strong{ISO 3 codes} (case-insensitive). For valid codes, see \code{country_codes()}.
Multiple values should be passed as a vector, e.g., \code{c("afg", "Indonesia", "bra")}.}

\item{inc_iso}{A logical value. If \code{TRUE}, the results data frame will
include the ISO3 country codes; otherwise, it will contain only country names.
\strong{Default:} \code{NULL}.}

\item{collection}{A character vector. Filters results by the data collection
repository ID, which is returned in the \code{repo_id} column by \code{collections()}.
Multiple IDs can be searched by passing a vector.}

\item{created}{A character string used to filter results by the \strong{date of creation}
or update within the catalog. Use the date format \code{YYYY-MM-DD}.
\itemize{
\item Single date: \code{"2020/04/01"} (returns records created on or after this date).
\item Date range: \code{"2020/04/01-2020/04/20"} (returns records within the range).
}}

\item{dtype}{A character vector. Filters results by one or more data access types.
Valid values include: \code{"open"}, \code{"direct"}, \code{"public"},
\code{"licensed"}, \code{"enclave"}, \code{"remote"}, and \code{"other"}.
See \code{access_codes()} for a list of available types by catalog.
Example: \code{c("open", "licensed")}.}

\item{sort_by}{A character string used to specify the column by which to sort the
results. Valid values are: \code{"rank"}, \code{"title"}, \code{"nation"} (for country),
or \code{"year"}. Note that "country" is automatically mapped to the API field "nation".}

\item{sort_order}{A character string indicating the sort direction.
Must be either \code{"asc"} (ascending) or \code{"desc"} (descending).}

\item{ps}{An integer indicating the number of records to display \strong{per page}
of results. \strong{Default:} \code{15} records.}

\item{page}{An integer specifying the \strong{page number} of the search results to return.}

\item{rows}{A logical value. If \code{TRUE}, the function returns only a data frame containing
the list of returned studies; otherwise, a list containing
detailed search metadata (e.g., total records found, total pages) instead of the
data records themselves. \strong{Default:} \code{TRUE}.}
}
\value{
If \code{rows = TRUE} (default), returns a \strong{data frame} where each row is a
data entry matching the search criteria.
If \code{rows = FALSE}, returns a \strong{list} containing search metadata, including
the total number of records found and the search parameters used.
}
\description{
Performs a comprehensive search in the specified catalog's API
endpoint, utilizing a full range of available searching, filtering, and sorting parameters.
}
\details{
This function constructs a complex API query based on the provided arguments (such
as keywords, temporal range, geography, and access types) and returns the matching
data entries. The function automatically handles URL encoding and JSON parsing.

All parameters correspond directly to the search options available on the NADA
(National Data Archive) platform used by organizations like the World Bank and FAO.
}
\examples{
\dontrun{
# Example 1: Basic search for a keyword in the World Bank catalog
wb_search <- search_catalog(
  catalog = "wb",
  keyword = "LSMS",
  ps = 5, # 5 records per page
  page = 1
)
head(wb_search)

# Example 2: Search by country and year range
fao_search <- search_catalog(
  catalog = "fao",
  country = c("Kenya", "UGA"),
  from = 2010,
  to = 2020,
  sort_by = "year",
  sort_order = "desc"
)

# Example 3: Filter by access type and get search information
ilo_info <- search_catalog(
  catalog = "ilo",
  keyword = "labor",
  dtype = "public",
  rows = FALSE
)
print(ilo_info$found) # Check total number of records found

# Example 4: Include ISO codes in results
ihsn_results <- search_catalog(
  catalog = "ihsn",
  inc_iso = TRUE
)
head(ihsn_results)
}
}
\seealso{
\code{\link{access_codes}}, \code{\link{collections}},
\code{\link{country_codes}}, \code{\link{latest_entries}}
}
\author{
Gutama Girja Urago
}
