% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-s4-class.R
\docType{class}
\name{Dmodel-class}
\alias{Dmodel-class}
\title{Dmodel S4 object}
\description{
S4 class that organizes the various data inputs for the MSA model. \code{MSAdata} simply inherits the slots from 6 component classes:
\code{Dmodel}, \code{Dstock}, \code{Dfishery}, \code{Dsurvey} \code{DCKMR}, and \code{Dtag}, where the \code{D}- prefix denotes an object for data inputs (or model configuration).
}
\details{
For convenience, most arrays and matrices have the associated dimensions in the variable name. For example, \code{Cobs_ymfr} represents
observed catch with the dimension following the underscore, following this template:

\tabular{ll}{
\code{y} \tab Year \cr
\code{m} \tab Season \cr
\code{a} \tab Age \cr
\code{r} \tab Region \cr
\code{f} \tab Fishery \cr
\code{i} \tab Index \cr
\code{s} \tab Stock
}
}
\section{Slots inherited from Dmodel}{

\describe{
\item{\code{ny}}{Integer, number of years}
\item{\code{nm}}{Integer, number of seasons}
\item{\code{na}}{Integer, number of ages. The first age class is zero and the last age class (plus group is age \code{na - 1}).}
\item{\code{nl}}{Integer, number of length bins. Set to zero if lengths are not modeled.}
\item{\code{nr}}{Integer, number of spatial regions}
\item{\code{ns}}{Integer, number of stocks}
\item{\code{lbin}}{Vector of lower boundary of length bins. Length \code{nl + 1}}
\item{\code{lmid}}{Vector of midpoint of length bins. Length \code{nl}}
\item{\code{Fmax}}{Numeric, maximum allowable instantaneous fishing mortality rate (units of per season). Defaults to 3.}
\item{\code{y_phi}}{Integer, the year from which to obtain values of natural mortality and fecundity for the unfished stock-recruit replacement line (\code{phi}). Relevant if natural mortality or fecundity are time-varying. Defaults to 1.}
\item{\code{scale_s}}{Vector, length \code{ns}. Multiplicative scaling factor that informs relative stock size to aid parameter estimation. Larger values implies larger stocks. Default set to 1. See \code{\link[=make_parameters]{make_parameters()}}.}
\item{\code{nyinit}}{Integer, number of years of spool-up to calculate equilibrium unfished and starting conditions for the population model to account for seasonal and spatial dynamics. The numerical spool-up is not needed when both \code{nm = 1} and \code{nr = 1}, i.e., \code{nyinit = 1}. Otherwise, set to \code{2 * na} by default.}
\item{\code{condition}}{Character, either to specify the model estimates fishing mortality as a parameter (\code{"F"}, default) or equal to the catch (\code{"catch"}).}
\item{\code{nitF}}{Integer, number of iterations to solve Baranov catch equation from observed catch if \code{condition = "catch"}. Defaults to 5.}
\item{\code{y_Fmult_f}}{Integer vector by fleet, the year in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{m_Fmult_f}}{Integer vector by fleet, the season in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{r_Fmult_f}}{Integer vector by fleet, the region in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{pbc_rdev_ys}}{Numeric matrix, for the fraction of lognormal bias correction (\code{-0.5 * sd_r^2}) applied to the recruitment estimates in the model. Typically between 0-1, with default of 1.}
\item{\code{pbc_initrdev_as}}{Numeric matrix, for the fraction of lognormal bias correction (\code{-0.5 * sd_r^2}) applied to the initial abundance vector in the model. Typically between 0-1, with default of 1.}
\item{\code{prior}}{Character vector to be evaluated in the model to return the log prior for a parameter. See example in documentation for \link{prior}.}
\item{\code{nyret}}{Integer, number of recent years of data to remove from the likelihood for retrospective analysis (positive numbers). Default is zero.}
}
}

\seealso{
\link{MSAdata-class} \code{\link[=check_data]{check_data()}} \link{Dmodel-class} \link{Dstock-class} \link{Dfishery-class} \link{Dsurvey-class} \link{DCKMR-class} \link{Dtag-class}
}
