% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rda.R
\name{rda}
\alias{rda}
\title{Redundancy analysis}
\usage{
rda(
  X_vars,
  Y_vars,
  data = NULL,
  Cov = NULL,
  numObs = NULL,
  extraTries = 50,
  ...
)
}
\arguments{
\item{X_vars}{A vector of characters of the X variables.}

\item{Y_vars}{A vector of characters of the Y variables.}

\item{data}{A data frame containing raw data. If NULL, \code{Cov} and
\code{numObs} must be provided.}

\item{Cov}{A covariance or correlation matrix. Required when \code{data} is NULL.}

\item{numObs}{A sample size. Required when \code{data} is NULL.}

\item{extraTries}{This function calls \code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} to obtain
parameter estimates and their standard errors. \code{extraTries} is the
number of extra runs. If \code{extraTries=0}, \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}} is
called.}

\item{...}{Additional arguments passed to either
\code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} or \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}}.}
}
\value{
A list with class \code{RDA}. It stores the model in OpenMx
objects. The fitted object is stored in \code{mx.fit}.
}
\description{
This function conducts redundancy analysis using the OpenMx package.
Missing data are handled with the full information maximum likelihood
method when raw data are available. It provides standard errors for
the standardized estimates.
}
\examples{
\donttest{
## Redundancy Analysis
rda(X_vars=c("x1", "x2", "x3", "x4"),
    Y_vars=c("y1", "y2", "y3"),
    data=sas_ex2)
}
}
\references{
Gu, F., Yung, Y.-F., Cheung, M. W.-L., Joo, B.-K., & Nimon, K.
(2023). Statistical inference in redundancy analysis: A direct
covariance structure modeling
approach. \emph{Multivariate Behavioral Research}, \strong{58(5)}, 877-893. \doi{10.1080/00273171.2022.2141675}
}
\seealso{
\link{Chittum19}, \link{sas_ex2}
}
\author{
Mike W.-L. Cheung \href{mailto:mikewlcheung@nus.edu.sg}{mikewlcheung@nus.edu.sg}
}
