% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpcr.R
\name{mpcr}
\alias{mpcr}
\title{Multivariate Principal Component Regression (MPCR)}
\usage{
mpcr(
  X_vars,
  Y_vars,
  data = NULL,
  Cov = NULL,
  Means = NULL,
  numObs = NULL,
  pca = c("COV", "COR"),
  pc_select = NULL,
  extraTries = 50,
  ...
)
}
\arguments{
\item{X_vars}{A vector of characters of the X variables.}

\item{Y_vars}{A vector of characters of the Y variables.}

\item{data}{A data frame containing raw data. If NULL, \code{Cov} and
\code{numObs} must be provided.}

\item{Cov}{A covariance or correlation matrix. Required when \code{data} is NULL.}

\item{Means}{An optional mean vector. Can be provided when \code{data} is NULL.}

\item{numObs}{A sample size. Required when \code{data} is NULL.}

\item{pca}{Whether principal component analysis is based on
unstandardized (\code{COV}) or standardized (\code{COR}) variables.}

\item{pc_select}{PCs selected in the regression analysis. For example,
\code{pc_select=c(1,2)} to use the first two PCs in the multiple
regression analysis.}

\item{extraTries}{This function calls \code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} to obtain
parameter estimates and their standard errors. \code{extraTries} is the
number of extra runs. If \code{extraTries=0}, \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}} is
called.}

\item{...}{Additional arguments passed to either
\code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} or \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}}.}
}
\value{
A list with class \code{MPCR}. It stores the model in OpenMx
objects. The fitted object is stored in \code{mx.fit}.
}
\description{
Conduct multivariate principal component regression
}
\details{
This function conducts multivariate principal component regression
using the OpenMx package. Missing data are handled with the full
information maximum likelihood method when raw data are available.
It provides standard errors for the estimates.
}
\examples{
\donttest{
## Multivariate Principal Component Regression
mpcr(X_vars=c("AU", "CC", "CL", "CO", "DF", "FB", "GR", "MW"),
     Y_vars=c("IDE", "IEE", "IOCB", "IPR", "ITS"),
     pca="COR", pc_select=1,
     data=Nimon21)
}
}
\references{
Gu, F., & Cheung, M. W.-L. (2023). A model-based approach to
multivariate principal component regression: Selection of principal
components and standard error estimates for unstandardized regression
coefficients. \emph{British Journal of Mathematical and Statistical
Psychology}, \strong{76(3)}, 605-622.
\doi{10.1111/bmsp.12301}
}
\seealso{
\link{Nimon21}
}
\author{
Mike W.-L. Cheung \href{mailto:mikewlcheung@nus.edu.sg}{mikewlcheung@nus.edu.sg}
}
