% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{Backdrop}
\alias{Backdrop}
\title{Backdrop}
\usage{
Backdrop(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/backdrop/}
}
\details{
\itemize{
\item open \code{bool} \cr Default is - If true, the component is shown.
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item component \code{elementType} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.
\item components \verb{\{ Root?: elementType \}} \cr Default is The components used for each slot inside.Deprecated Use the slots prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item componentsProps \verb{\{ root?: object \}} \cr Default is The extra props for the slot components. You can override the existing props or add new ones.Deprecated Use the slotProps prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item invisible \code{bool} \cr Default is FALSE If true, the backdrop is invisible. It can be used when rendering a popover or a custom select component.
\item slotProps \verb{\{ root?: func| object, transition?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ root?: elementType, transition?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item TransitionComponent \code{elementType} \cr Default is Fade The component used for the transition. Follow this guide to learn more about the requirements for this component.Deprecated Use slots.transition instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item transitionDuration \verb{number| \{ appear?: number, enter?: number, exit?: number \}} \cr Default is - The duration for the transition, in milliseconds. You may specify a single timeout for all transitions, or individually with an object.
}
}
