% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_covs.R
\name{compute_data_driven_covs}
\alias{compute_data_driven_covs}
\title{Compute data-driven covariance matrices.}
\usage{
compute_data_driven_covs(
  sumstats,
  subset_thresh = NULL,
  n_pcs = 3,
  flash_factors = c("default", "nonneg"),
  flash_remove_singleton = FALSE,
  Gamma = diag(ncol(sumstats$Bhat))
)
}
\arguments{
\item{sumstats}{a list with two elements. 1 - Bhat, a numeric vector of regression coefficients.
2 - Shat, a numeric vector of of standard erros for the regression coefficients.}

\item{subset_thresh}{scalar indicating the threshold for selecting the effects to be used for computing 
the covariance matrices based on false local sign rate (lfsr) for a response-by-response ash analysis.}

\item{n_pcs}{indicating the number of principal components to be selected.}

\item{flash_factors}{factors "default" to use \code{flashr} default function to initialize factors, currently \code{udv_si}. 
"nonneg" to implement a non-negative constraint on the factors}

\item{flash_remove_singleton}{whether or not factors corresponding to singleton matrices should be removed from output.}

\item{Gamma}{an r x r correlation matrix for the residuals; must be positive
definite.}
}
\value{
A list containing the (de-noised) data-driven covariance matrices.
}
\description{
Function to compute data-driven covariance matrices from summary statistics
  using PCA, FLASH and the sample covariance. These matrices are de-noised using Extreme Deconvolution.
}
