% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{mpspline_compact}
\alias{mpspline_compact}
\alias{mpspline_tidy}
\title{Spline discrete soils data - multiple sites}
\usage{
mpspline_compact(
  obj = NULL,
  var_name = NULL,
  lam = 0.1,
  d = c(0, 5, 15, 30, 60, 100, 200),
  vlow = 0,
  vhigh = 1000
)

mpspline_tidy(
  obj = NULL,
  var_name = NULL,
  lam = 0.1,
  d = c(0, 5, 15, 30, 60, 100, 200),
  vlow = 0,
  vhigh = 1000
)
}
\arguments{
\item{obj}{data.frame or matrix. Column 1 must contain site identifiers.
Columns 2 and 3 must contain upper and lower sample depths, respectively,
measured in centimeters. Subsequent columns will contain measured values
for those depths.}

\item{var_name}{character or integer vector denoting the column(s) in
\code{obj} in which target data is stored. If not supplied, the fourth
column of the input object is assumed to contain the target data.}

\item{lam}{number; smoothing parameter for spline. Defaults to 0.1.}

\item{d}{sequential integer vector; denotes the output depth ranges in cm.
Defaults to \code{c(0, 5, 15, 30, 60, 100, 200)} after the GlobalSoilMap
specification, giving output predictions over intervals 0-5cm, 5-15cm,
etc.}

\item{vlow}{numeric; constrains the minimum predicted value to a realistic
number. Defaults to 0.}

\item{vhigh}{numeric; constrains the maximum predicted value to a realistic
number. Defaults to 1000.}
}
\value{
\code{mpspline_compact()} returns a four-item list containing matrices:
  predicted values over input depth ranges, output depth ranges, 1cm predictions,
  and RMSE values. Site identifiers are in rownames.

  \code{mpspline_tidy()} returns a four-item list of data frames with the
  same predictions but in tidy format, with an added VARIABLE column when
  processing multiple variables.
}
\description{
These functions implement the mass-preserving spline method of Bishop \emph{et
al} (1999) (\doi{10.1016/S0016-7061(99)00003-8}) for interpolating between
measured soil attributes down a soil profile, across multiple sites' worth of
data. \code{mpspline_compact()} returns results as matrices while
\code{mpspline_tidy()} returns results as data frames.
}
\examples{
dat <- data.frame("SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                   "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                   "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                  "VAL" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                   stringsAsFactors = FALSE)
# single variable
result <- mpspline_compact(obj = dat, var_name = 'VAL')

# multiple variables
dat_multi <- data.frame( "SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                          "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                          "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                        "VAL1" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                        "VAL2" = c( 5,  3,  2,  9, 0.2, 1.0, 2.0,   5),
                        stringsAsFactors = FALSE)
result_multi <- mpspline_compact(obj = dat_multi, var_name = c('VAL1', 'VAL2'))
\dontshow{
# Reuse example data from mpspline_compact
dat <- data.frame("SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                   "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                   "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                  "VAL" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                   stringsAsFactors = FALSE)
}
# Single variable with tidy output
result <- mpspline_tidy(obj = dat, var_name = 'VAL')

# Multiple variables
dat_multi <- data.frame( "SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                          "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                          "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                        "VAL1" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                        "VAL2" = c( 5,  3,  2,  9, 0.2, 1.0, 2.0,   5),
                        stringsAsFactors = FALSE)
result_multi <- mpspline_tidy(obj = dat_multi, var_name = c('VAL1', 'VAL2'))
subset(result_multi$est_dcm, VARIABLE == 'VAL1')
}
