% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fns.R
\name{read_excel}
\alias{read_excel}
\title{Read an Excel file into a DuckDB/MotherDuck table}
\usage{
read_excel(
  .con,
  to_database_name,
  to_schema_name,
  to_table_name,
  file_path,
  header,
  sheet,
  all_varchar,
  ignore_errors,
  range,
  stop_at_empty,
  empty_as_varchar,
  write_type
)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{to_database_name}{Target database name (new or existing)}

\item{to_schema_name}{Target schema name  (new or existing)}

\item{to_table_name}{Target table name to create  (new or existing)}

\item{file_path}{Path to the Excel file (\code{.xlsx})}

\item{header}{Logical; if \code{TRUE}, first row is header}

\item{sheet}{Character; sheet name to read (defaults to first sheet)}

\item{all_varchar}{Logical; coerce all columns to \code{VARCHAR}}

\item{ignore_errors}{Logical; continue on cell/row errors}

\item{range}{Character; Excel range like \code{"A1"} or \code{"A1:C100"}}

\item{stop_at_empty}{Logical; stop at first completely empty row}

\item{empty_as_varchar}{Logical; treat empty columns as \code{VARCHAR}}

\item{write_type}{Logical, will drop previous table and replace with new table}
}
\value{
Invisibly returns \code{NULL}.
Side effect: creates \verb{<database>.<schema>.<table>} with the Excel data.
}
\description{
Loads the DuckDB \strong{excel} extension and creates a table from an Excel file
using the \code{read_xlsx()} table function. The destination is fully qualified
as \verb{<database>.<schema>.<table>}. Only the options you supply are forwarded
to \code{read_xlsx()} (e.g., \code{sheet}, \code{header}, \code{all_varchar}, \code{ignore_errors},
\code{range}, \code{stop_at_empty}, \code{empty_as_varchar}).
See 'duckdb extension \href{https://duckdb.org/docs/stable/core_extensions/excel}{read_excel} for more information
}
\seealso{
Other db-read: 
\code{\link{read_csv}()}
}
\concept{db-read}
