% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmvgamma.R
\name{lmvgamma}
\alias{lmvgamma}
\title{Log multivariate gamma function}
\usage{
lmvgamma(a, p)
}
\arguments{
\item{a}{Numeric. Argument of \eqn{\Gamma_p(\cdot)} (often \eqn{\nu/2}
in Wishart contexts).}

\item{p}{Integer. Dimension \eqn{p} of the multivariate gamma.}
}
\value{
A numeric scalar equal to \eqn{\log \Gamma_p(a)}.
}
\description{
Compute the log of the multivariate gamma function \eqn{\log \Gamma_p(a)}
for dimension \eqn{p} and parameter \eqn{a}.
}
\details{
The multivariate gamma function \eqn{\Gamma_p(a)} is defined by:
\deqn{
  \Gamma_p(a)
  = \pi^{\,p(p-1)/4} \prod_{j=1}^{p} \Gamma\!\left(a + \frac{1-j}{2}\right).
}

Constraints: (i) \eqn{p \in \{1,2,\dots\}} (positive integer), and
  (ii) \eqn{a > (p-1)/2} to keep all gamma terms finite (as in the Wishart
  normalization constant).
}
\examples{

# Dimension
p <- 3
# Evaluate log multivariate gamma at a = nu/2
nu <- p + 5
lmvgamma(a = nu / 2, p = p)

}
