% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-residuals.R
\name{modeltime_residuals}
\alias{modeltime_residuals}
\title{Extract Residuals Information}
\usage{
modeltime_residuals(object, new_data = NULL, quiet = TRUE, ...)
}
\arguments{
\item{object}{A Modeltime Table}

\item{new_data}{A \code{tibble} to predict and calculate residuals on.
If provided, overrides any calibration data.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them as they occur?}

\item{...}{Not currently used.}
}
\value{
A tibble with residuals.
}
\description{
This is a convenience function to unnest model residuals
}
\examples{
library(dplyr)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- RESIDUALS ----

# In-Sample
models_tbl \%>\%
    modeltime_calibrate(new_data = training(splits)) \%>\%
    modeltime_residuals() \%>\%
    plot_modeltime_residuals(.interactive = FALSE)

# Out-of-Sample
models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_residuals() \%>\%
    plot_modeltime_residuals(.interactive = FALSE)


}
