% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_lightgbm.R
\name{LearnerLightgbm}
\alias{LearnerLightgbm}
\title{R6 Class to construct a LightGBM learner}
\description{
The \code{LearnerLightgbm} class is the interface to the \code{lightgbm} R package for
use with the \code{mlexperiments} package.
}
\details{
Optimization metric: needs to be specified with the learner parameter
\code{metric}. The following options can be set via \code{options()}:
\itemize{
\item "mlexperiments.optim.lgb.nrounds" (default: \code{5000L})
\item "mlexperiments.optim.lgb.early_stopping_rounds" (default: \code{500L})
\item "mlexperiments.lgb.print_every_n" (default: \code{50L})
\item "mlexperiments.lgb.verbose" (default: \code{-1L})
}

\code{LearnerLightgbm} can be used with
\itemize{
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}
}
\examples{
# binary classification

library(mlbench)
data("PimaIndiansDiabetes2")
dataset <- PimaIndiansDiabetes2 |>
  data.table::as.data.table() |>
  na.omit()

seed <- 123
feature_cols <- colnames(dataset)[1:8]

param_list_lightgbm <- expand.grid(
  bagging_fraction = seq(0.6, 1, .2),
  feature_fraction = seq(0.6, 1, .2),
  min_data_in_leaf = seq(10, 50, 10),
  learning_rate = seq(0.1, 0.2, 0.1),
  num_leaves = seq(10, 50, 10),
  max_depth = -1L
)

train_x <- model.matrix(
  ~ -1 + .,
  dataset[, .SD, .SDcols = feature_cols]
)
train_y <- as.integer(dataset[, get("diabetes")]) - 1L

fold_list <- splitTools::create_folds(
  y = train_y,
  k = 3,
  type = "stratified",
  seed = seed
)
lightgbm_cv <- mlexperiments::MLCrossValidation$new(
  learner = mllrnrs::LearnerLightgbm$new(
    metric_optimization_higher_better = FALSE
  ),
  fold_list = fold_list,
  ncores = 2,
  seed = 123
)
lightgbm_cv$learner_args <- c(
  as.list(
    data.table::data.table(
      param_list_lightgbm[37, ],
      stringsAsFactors = FALSE
    ),
  ),
  list(
    objective = "binary",
    metric = "binary_logloss"
  ),
  nrounds = 45L
)
lightgbm_cv$performance_metric_args <- list(positive = "1", negative = "0")
lightgbm_cv$performance_metric <- mlexperiments::metric("AUC")

# set data
lightgbm_cv$set_data(
  x = train_x,
  y = train_y
)

lightgbm_cv$execute()


## ------------------------------------------------
## Method `LearnerLightgbm$new`
## ------------------------------------------------

LearnerLightgbm$new(metric_optimization_higher_better = FALSE)

}
\seealso{
\code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}}, \code{\link[lightgbm:lgb.cv]{lightgbm::lgb.cv()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerLightgbm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerLightgbm-new}{\code{LearnerLightgbm$new()}}
\item \href{#method-LearnerLightgbm-clone}{\code{LearnerLightgbm$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerLightgbm-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerLightgbm-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerLightgbm} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerLightgbm$new(metric_optimization_higher_better)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric_optimization_higher_better}}{A logical. Defines the direction
of the optimization metric used throughout the hyperparameter
optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LearnerLightgbm} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerLightgbm$new(metric_optimization_higher_better = FALSE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerLightgbm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerLightgbm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerLightgbm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
