% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptions.R
\name{mp_assumptions}
\alias{mp_assumptions}
\title{Create modeling assumptions for simulation-based power}
\usage{
mp_assumptions(fixed_effects, icc = NULL, residual_sd = NULL, notes = NULL)
}
\arguments{
\item{fixed_effects}{Named list of numeric values (e.g., \code{list(condition = 0.4)}).}

\item{icc}{Optional named list of ICC values in [0, 1).}

\item{residual_sd}{Optional non-negative numeric residual SD.}

\item{notes}{Optional free text.}
}
\value{
An object of class \code{mp_assumptions}.
}
\description{
Assumptions encode effect sizes and nuisance parameters. Values may be scalars
or vectors (for later sensitivity workflows), but \code{mp_power()} expects scalars
unless used inside a grid wrapper.
}
\examples{
a <- mp_assumptions(fixed_effects = list(condition = 0.4), residual_sd = 1)
a
}
