% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blimp.run.R
\name{blimp.run}
\alias{blimp.run}
\title{Run Blimp Models}
\usage{
blimp.run(target = getwd(), recursive = FALSE,
          replace.out = c("always", "never", "modified"), posterior = FALSE,
          folder = "Posterior_", format = c("csv", "csv2", "xlsx", "rds", "RData"),
          clear = FALSE, Blimp = .detect.blimp(), check = TRUE)
}
\arguments{
\item{target}{a character string indicating the directory containing
Blimp input files (\code{.imp}) to run, a character string
indicating a single \code{.imp} file to run, or a character
vector for multiple \code{.imp} files to run. May be a full
path, relative path, a file name, or a vector of file names
within the working directory.}

\item{recursive}{logical: if \code{TRUE}, run all models nested in subdirectories
within a directory. Not relevant if a single or multiple \code{.imp}
files were specified for the argument \code{target}.}

\item{replace.out}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modified"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{posterior}{logical: if \code{TRUE}, the posterior distribution including
burn-in and post-burn-in phase for all parameters are saved
in long format in a file called \code{posterior.*} in the folder
specified in the argument \code{folder} and \code{.imp} file
name in the format specified in the argument \code{format}.}

\item{folder}{a character string indicating the prefix of the folder for
saving the posterior distributions. The default setting is
\code{folder = "Posterior_"}.}

\item{format}{a character vector indicating the file format(s) for saving the
posterior distributions, i.e., \code{"csv"} (default) for
\code{write.csv()}, \code{"csv2"} for \code{write.csv2()},
\code{"xlsx"} for \code{write.xlsx()}, \code{"rds"} for
\code{saveRDS()}, and \code{"RData"} for \code{write()}.}

\item{clear}{logical: if \code{TRUE}, the console is cleared
after estimating each model.}

\item{Blimp}{a character string for specifying the name or path of the
Blimp executable to be used for running models. This covers
situations where Blimp is not in the system's path, or where
one wants to test different versions of the Blimp program.
Note that there is no need to specify this argument for most
users since it has intelligent defaults.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
}
\value{
None.
}
\description{
This function runs a group of Blimp models (\code{.imp} files) located within a
single directory or nested within subdirectories.
}
\note{
This function is based on the \code{detect_blimp()} and \code{rblimp()} function
in the \pkg{rblimp} package by Brian T.Keller (2024).
}
\examples{
\dontrun{

# Example 1: Run Blimp models located within the current working directory
blimp.run()

# Example 2: Run Blimp models located nested within subdirectories
blimp.run(recursive = TRUE)

# Example 3: Run Blimp input file
blimp.run("Ex4.1a.imp")

# Example 4: Run Blimp input files
blimp.run(c("Ex4.1a.imp", "Ex4.1b.imp"))

# Example 5: Run Blimp models, save posterior distribution in a R workspace
blimp.run(posterior = TRUE, format = "workspace")
}
}
\references{
Keller, B. T., & Enders, C. K. (2023). \emph{Blimp user’s guide} (Version 3). Retrieved
from www.appliedmissingdata.com/blimp

Keller B (2024). \emph{rblimp: Integration of Blimp Software into R}. R package
version 0.1.31. https://github.com/blimp-stats/rblimp
}
\seealso{
\code{\link{blimp}}, \code{\link{blimp.update}}, \code{\link{blimp.print}}, \code{\link{blimp.plot}}, \code{\link{blimp.bayes}}
}
\author{
Takuya Yanagida
}
