% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-operations.R
\name{gintervals.path}
\alias{gintervals.path}
\title{Returns the path on disk of an interval set}
\usage{
gintervals.path(intervals.set = NULL)
}
\arguments{
\item{intervals.set}{name of an interval set or a vector of interval set names}
}
\value{
A character vector containing the full paths to the interval sets on disk.
}
\description{
Returns the path on disk of an interval set.
}
\details{
This function returns the actual file system path where an interval set is stored.
The function works with a single interval set name or a vector of names.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gintervals.path("annotations")
gintervals.path(c("annotations", "coding"))

}
\seealso{
\code{\link{gintervals.exists}}, \code{\link{gintervals.ls}},
\code{\link{gtrack.path}}
}
\keyword{~intervals}
\keyword{~path}
