% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{make_cluster}
\alias{make_cluster}
\alias{stop_cluster}
\title{Make Mirai Cluster}
\usage{
make_cluster(n, url = NULL, remote = NULL, ...)

stop_cluster(cl)
}
\arguments{
\item{n}{(integer) number of nodes. Launched locally unless \code{url} is
supplied.}

\item{url}{(character) host URL for remote nodes to dial into, e.g.
'tcp://10.75.37.40:5555'. Use 'tls+tcp://' for secure TLS.}

\item{remote}{(configuration) for launching remote nodes, generated by
\code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}}, or \code{\link[=remote_config]{remote_config()}}.}

\item{...}{(daemons arguments) passed to \code{\link[=daemons]{daemons()}}.}

\item{cl}{(miraiCluster) cluster to stop.}
}
\value{
For \strong{make_cluster}: An object of class 'miraiCluster' and
'cluster'. Each 'miraiCluster' has an automatically assigned ID and \code{n}
nodes of class 'miraiNode'. If \code{url} is supplied but not \code{remote}, the
shell commands for deployment of nodes on remote resources are printed to
the console.

For \strong{stop_cluster}: invisible NULL.
}
\description{
\code{make_cluster} creates a cluster of type 'miraiCluster', which may be used as
a cluster object for any function in the \pkg{parallel} base package such as
\code{\link[parallel:clusterApply]{parallel::clusterApply()}} or \code{\link[parallel:clusterApply]{parallel::parLapply()}}.

\code{stop_cluster} stops a cluster created by \code{make_cluster}.
}
\details{
For R version 4.5 or newer, \code{\link[parallel:makeCluster]{parallel::makeCluster()}} specifying
\code{type = "MIRAI"} is equivalent to this function.
}
\note{
The default behaviour of clusters created by this function is designed
to map as closely as possible to clusters created by the \pkg{parallel}
package. However, \code{...} arguments are passed to \code{\link[=daemons]{daemons()}} for additional
customisation, and not all combinations may be supported by \pkg{parallel}
functions.
}
\section{Remote Nodes}{


Specify \code{url} and \code{n} to set up a host connection for remote nodes to dial
into. \code{n} defaults to one if not specified.

Also specify \code{remote} to launch the nodes using a configuration generated by
\code{\link[=remote_config]{remote_config()}} or \code{\link[=ssh_config]{ssh_config()}}. In this case, the number of nodes is
inferred from the configuration provided and \code{n} is disregarded.

If \code{remote} is not supplied, the shell commands for deploying nodes manually
on remote resources are automatically printed to the console.

\code{\link[=launch_remote]{launch_remote()}} may be called at any time on a 'miraiCluster' to return the
shell commands for deployment of all nodes, or on a 'miraiNode' to return the
command for a single node.
}

\section{Errors}{


Errors are thrown by the \pkg{parallel} package mechanism if one or more
nodes failed (quit unexpectedly). The returned 'errorValue' is 19
(Connection reset). Other types of error, e.g. in evaluation, result in the
usual 'miraiError' being returned.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
cl <- make_cluster(2)
cl
cl[[1L]]

Sys.sleep(0.5)
status(cl)

stop_cluster(cl)
\dontshow{\}) # examplesIf}
}
