% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{resolve_weight_spec}
\alias{resolve_weight_spec}
\title{Resolve a portable weight specification to a usable weight configuration}
\usage{
resolve_weight_spec(weight_spec, dest_dir = tempdir())
}
\arguments{
\item{weight_spec}{Named list from RecipeWorkflow$weight_spec}

\item{dest_dir}{Character directory for downloaded files (default: tempdir())}
}
\value{
Named list compatible with add_weight() output
}
\description{
Converts the portable weight_spec from a RecipeWorkflow back into the
format expected by \code{load_survey()} and \code{add_weight()}.
For replicate weights with ANDA sources, automatically downloads the
replicate file.
}
\examples{
\dontrun{
wf <- api_get_workflow("w_123")
weight <- resolve_weight_spec(wf$weight_spec)
}
}
\seealso{
Other weights: 
\code{\link{add_replicate}()},
\code{\link{add_weight}()}
}
\concept{weights}
