% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals.R
\name{trial_totals}
\alias{trial_totals}
\title{Trial Probability and Expected Counts}
\usage{
trial_totals(
  mcmodule,
  mc_names,
  trials_n,
  subsets_n = NULL,
  subsets_p = NULL,
  name = NULL,
  prefix = NULL,
  combine_prob = TRUE,
  all_suffix = NULL,
  level_suffix = c(trial = "trial", subset = "subset", set = "set"),
  mctable = set_mctable(),
  agg_keys = NULL,
  agg_suffix = NULL,
  keep_variates = FALSE,
  summary = TRUE,
  data_name = NULL
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing input data and node structure.}

\item{mc_names}{(character vector). Node names to process.}

\item{trials_n}{(character). Trial count column name.}

\item{subsets_n}{(character, optional). Subset count column name. Default: NULL.}

\item{subsets_p}{(character, optional). Subset prevalence column name. Default: NULL.}

\item{name}{(character, optional). Custom name for output nodes. Default: NULL.}

\item{prefix}{(character, optional). Prefix for output node names. Default: NULL.}

\item{combine_prob}{(logical). If TRUE, combine probability of all nodes assuming
independence. Default: TRUE.}

\item{all_suffix}{(character). Suffix for combined node name. Default: "all".}

\item{level_suffix}{(list, optional). Suffixes for each hierarchical level.
Default: c(trial="trial", subset="subset", set="set").}

\item{mctable}{(data frame, optional). Monte Carlo nodes definitions.
Default: set_mctable().}

\item{agg_keys}{(character vector, optional). Column names for aggregation.
Default: NULL.}

\item{agg_suffix}{(character). Suffix for aggregated node names. Default: "hag".}

\item{keep_variates}{(logical). If TRUE, preserve individual variate values.
Default: FALSE.}

\item{summary}{(logical). If TRUE, include summary statistics. Default: TRUE.}

\item{data_name}{(character, optional). Data name used to create trials_n,
subsets_n and subsets_p nodes if they don't exist in mcmodule. Default: NULL.}
}
\value{
Updated mcmodule object containing combined node probabilities and
probabilities/counts at trial, subset, and set levels.
}
\description{
Calculates probabilities and expected counts across hierarchical levels
(trial, subset, set) in a structured population. Uses trial probabilities and
handles nested sampling with conditional probabilities.
}
\examples{
imports_mcmodule <- trial_totals(
  mcmodule = imports_mcmodule,
  mc_names = "no_detect_a",
  trials_n = "animals_n",
  subsets_n = "farms_n",
  subsets_p = "h_prev",
  mctable = imports_mctable
)
print(imports_mcmodule$node_list$no_detect_a_set$summary)
}
