% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_match.R
\name{mc_match_data}
\alias{mc_match_data}
\title{Match Monte Carlo Node with Data Frame}
\usage{
mc_match_data(mcmodule, mc_name, data, keys_names = NULL)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node.}

\item{mc_name}{(character). Node name.}

\item{data}{(data frame). Data to match with mcnode.}

\item{keys_names}{(character vector, optional). Column names for matching.
Default: NULL.}
}
\value{
A list containing matched mcnode, matched data, and combined keys
(\code{keys_xy}).
}
\description{
Matches an mcnode with a data frame by aligning groups, scenarios, or adding
missing groups across different scenarios.
}
\details{
Matching proceeds in order:
\enumerate{
\item Group matching — same scenarios but different group order
\item Scenario matching — same groups but different scenarios
\item Null matching — add missing groups across different scenarios
}
}
\examples{
test_data  <- data.frame(pathogen=c("a","b"),
                         inf_dc_min=c(0.05,0.3),
                         inf_dc_max=c(0.08,0.4))
result<-mc_match_data(imports_mcmodule,"no_detect_a", test_data)
}
