% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_bias_correct_std.R
\name{mc_bias_corrected_std}
\alias{mc_bias_corrected_std}
\title{Bias-corrected Standard Error for Regression Parameters}
\source{
Nuamah, I. F. and Qu, Y. and Aminu, S. B. (1996). A SAS macro
for stepwise correlated binary regression. Computer Methods
and Programs in Biomedicine 49, 199--210.
}
\usage{
mc_bias_corrected_std(object, id)
}
\arguments{
\item{object}{an object of \code{mcglm} class.}

\item{id}{a vector which identifies the clusters. The length and
order of \code{id} should be the same as the number of
observations. The data set are assumed to be sorted so that
observations on a cluster are contiguous rows for all entities.}
}
\value{
A list with two elements. A vector of standard error and a variance-covariance
    matrix computed based on a bias corrected approach as described in the reference.
}
\description{
Compute bias-corrected standard error for regression
    parameters in the context of clustered observations for an
    object of \code{mcglm} class. It is also robust and has improved
    finite sample properties.
}
\seealso{
\code{mc_robust_std}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
