% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{mcc_method}
\alias{mcc_method}
\title{Get the method used for MCC calculation}
\usage{
mcc_method(x)
}
\arguments{
\item{x}{An \code{mcc} object}
}
\value{
Character string indicating the method ("equation" or "sci")
}
\description{
Get the method used for MCC calculation
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2),
  group = c("A", "A", "B", "B", "B", "B", "B", "A", "A")
) |>
  arrange(id, time)

# Calculate MCC
mcc_result <- mcc(df, "id", "time", "cause")

# Get the method used
mcc_method(mcc_result)

# Clean up
rm(df, mcc_result)
}
