% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{mds_mappoly}
\alias{mds_mappoly}
\alias{print.mappoly.pcmap}
\alias{print.mappoly.pcmap3d}
\title{Estimates loci position using Multidimensional Scaling}
\usage{
mds_mappoly(
  input.mat,
  p = NULL,
  n = NULL,
  ndim = 2,
  weight.exponent = 2,
  verbose = TRUE
)

\method{print}{mappoly.pcmap}(x, ...)

\method{print}{mappoly.pcmap3d}(x, ...)
}
\arguments{
\item{input.mat}{an object of class \code{mappoly.input.matrix}}

\item{p}{integer. The smoothing parameter for the principal curve.
If \code{NULL} (default) this will be done using the leave-one-out cross validation}

\item{n}{vector of integers or strings containing loci to be omitted from the analysis}

\item{ndim}{number of dimensions to be considered in the multidimensional scaling procedure (default = 2)}

\item{weight.exponent}{the exponent that should be used in the LOD score values to weight the
MDS procedure (default = 2)}

\item{verbose}{if \code{TRUE} (default), display information about the analysis}

\item{x}{an object of class \code{mappoly.mds}}

\item{...}{currently ignored}
}
\value{
A list containing:
\item{M}{the input distance map}
\item{sm}{the unconstrained MDS results}
\item{pc}{the principal curve results}
\item{distmap}{a matrix of pairwise distances between
loci where the columns are in the estimated order}
\item{locimap}{a data frame of the loci containing the name
and position of each locus in order of increasing distance}
\item{length}{integer giving the total length of the segment}
\item{removed}{a vector of the names of loci removed from the analysis}
\item{scale}{the scaling factor from the MDS}
\item{locikey}{a data frame showing the number associated with each
locus name for interpreting the MDS configuration plot}
\item{confplotno}{a data frame showing locus name associated
with each number on the MDS configuration plots}
}
\description{
Estimates loci position using Multidimensional Scaling proposed by
\cite{Preedy and Hackett (2016)}. The code is an adaptation from
the package \code{MDSmap}, available under GNU GENERAL PUBLIC LICENSE,
Version 3, at \url{https://CRAN.R-project.org/package=MDSMap}
}
\examples{
    s1 <- make_seq_mappoly(hexafake, 1:20)
    t1 <- est_pairwise_rf(s1, ncpus = 1)
    m1 <- rf_list_to_matrix(t1)
    o1 <- get_genomic_order(s1)
    s.go <- make_seq_mappoly(o1)
    plot(m1, ord = s.go$seq.mrk.names)
    mds.ord <- mds_mappoly(m1)
    plot(mds.ord)
    so <- make_seq_mappoly(mds.ord)
    plot(m1, ord = so$seq.mrk.names)
    plot(so$seq.num ~ I(so$genome.pos/1e6), 
         xlab = "Genome Position",
         ylab = "MDS position")

}
\references{
Preedy, K. F., & Hackett, C. A. (2016). A rapid marker ordering approach for
 high-density genetic linkage maps in experimental autotetraploid populations
 using multidimensional scaling. _Theoretical and Applied Genetics_, 129(11),
 2117-2132. \doi{10.1007/s00122-016-2761-8}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} mostly adapted from MDSmap 
        codes, written by Katharine F. Preedy, \email{katharine.preedy@bioss.ac.uk}
}
