% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_concave_hull}
\alias{turf_concave_hull}
\title{Create concave hull}
\usage{
turf_concave_hull(
  map,
  layer_id = NULL,
  data = NULL,
  coordinates = NULL,
  max_edge = NULL,
  units = "kilometers",
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of a layer or source containing points (mutually exclusive with data and coordinates).}

\item{data}{An sf object containing points (mutually exclusive with layer_id and coordinates).}

\item{coordinates}{A list of coordinate pairs list(c(lng,lat), c(lng,lat), ...) for multiple points (mutually exclusive with layer_id and data).}

\item{max_edge}{The maximum edge length for the concave hull. If NULL (default), an optimal value is calculated automatically.}

\item{units}{The units for max_edge. One of "meters", "kilometers", "miles", etc.}

\item{source_id}{The ID for the new source containing the concave hull. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function creates a concave hull around a set of points.
The result is added as a source to the map, which can then be styled using add_fill_layer(), etc.
}
\details{
If max_edge is too small and no concave hull can be computed, the function will automatically
calculate an optimal max_edge value based on point distances. If that fails, it falls back
to a convex hull to ensure a result is always returned.
}
