% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_create.R
\name{make_create}
\alias{make_create}
\alias{create_empty}
\alias{create_filled}
\alias{create_ring}
\alias{create_star}
\alias{create_tree}
\alias{create_lattice}
\alias{create_components}
\alias{create_degree}
\alias{create_core}
\alias{create_windmill}
\alias{create_cycle}
\alias{create_wheel}
\title{Making networks with defined structures}
\usage{
create_empty(n, directed = FALSE)

create_filled(n, directed = FALSE)

create_ring(n, directed = FALSE, width = 1, ...)

create_star(n, directed = FALSE)

create_tree(n, directed = FALSE, width = 2)

create_lattice(n, directed = FALSE, width = 8)

create_components(n, directed = FALSE, membership = NULL)

create_degree(n, outdegree = NULL, indegree = NULL)

create_core(n, directed = FALSE, mark = NULL)

create_windmill(n)

create_cycle(n)

create_wheel(n)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{directed}{Logical whether the graph should be directed.
By default \code{directed = FALSE}.
If the opposite direction is desired,
use \code{to_redirected()} on the output of these functions.}

\item{width}{Integer specifying the width of the ring,
breadth of the branches, or maximum extent of the neighbourbood.}

\item{...}{Additional arguments passed on to \code{igraph::make_ring()}.}

\item{membership}{A vector of partition membership as integers.
If left as \code{NULL} (the default), nodes in each mode will be
assigned to two, equally sized partitions.}

\item{outdegree}{Numeric scalar or vector indicating the
desired outdegree distribution.
By default NULL and is required.
If \code{n} is an existing network object and the outdegree is not specified,
then the outdegree distribution will be inferred from that of the network.
Note that a scalar (single number) will result in a k-regular graph.}

\item{indegree}{Numeric vector indicating the desired indegree distribution.
By default NULL but not required unless a directed network is desired.
If \code{n} is an existing directed network object and the indegree is not specified,
then the indegree distribution will be inferred from that of the network.}

\item{mark}{A logical vector the length of the nodes in the network.
This can be created by, among other things, any \verb{node_is_*()} function.}
}
\value{
By default a \code{tbl_graph} object is returned,
but this can be coerced into other types of objects
using \code{as_edgelist()}, \code{as_matrix()},
\code{as_tidygraph()}, or \code{as_network()}.

By default, all networks are created as undirected.
This can be overruled with the argument \code{directed = TRUE}.
This will return a directed network in which the arcs are
out-facing or equivalent.
This direction can be swapped using \code{to_redirected()}.
In two-mode networks, the directed argument is ignored.
}
\description{
These functions create networks with particular structural properties.
\itemize{
\item \code{create_empty()} creates an empty network without any ties.
\item \code{create_filled()} creates a filled network with every possible tie realised.
\item \code{create_ring()} creates a ring or chord network where each nodes'
neighbours form a clique.
\item \code{create_star()} creates a network with a maximally central node.
\item \code{create_tree()} creates a network with successive branches.
\item \code{create_lattice()} creates a network that forms a regular tiling.
\item \code{create_components()} creates a network that clusters nodes into separate components.
\item \code{create_core()} creates a network in which a certain proportion of 'core' nodes
are densely tied to each other, and the rest peripheral, tied only to the core.
\item \code{create_degree()} creates a network with a given (out/in)degree sequence,
which can also be used to create k-regular networks.
}

These functions can create either one-mode or two-mode networks.
To create a one-mode network, pass the main argument \code{n} a single integer,
indicating the number of nodes in the network.
To create a two-mode network, pass \code{n} a vector of \emph{two} integers,
where the first integer indicates the number of nodes in the first mode,
and the second integer indicates the number of nodes in the second mode.
As an alternative, an existing network can be provided to \code{n}
and the number of modes, nodes, and directedness will be inferred.
}
\section{Lattice graphs}{

\code{create_lattice()} creates both two-dimensional grid and triangular
lattices with as even dimensions as possible.
When the \code{width} parameter is set to 4, nodes cannot have (in or out)
degrees larger than 4.
This creates regular square grid lattices where possible.
Such a network is bipartite, that is partitionable into two types that are
not adjacent to any of their own type.
If the number of nodes is a prime number, it will only return a chain
(a single dimensional lattice).

A \code{width} parameter of 8 creates a network where the maximum degree of any
nodes is 8.
This can create a triangular mesh lattice or a Queen's move lattice,
depending on the dimensions.
A \code{width} parameter of 12 creates a network where the maximum degree of
any nodes is 12.
Prime numbers of nodes will return a chain.
}

\examples{
create_empty(10)
create_filled(10)
create_ring(8, width = 2)
create_star(12)
create_tree(c(7,8))
create_lattice(12, width = 4)
create_components(10, membership = c(1,1,1,2,2,2,3,3,3,3))
create_degree(10, outdegree = rep(1:5, 2))
create_core(6)
  create_windmill(6)
  create_cycle(6)
  create_wheel(6)
}
\seealso{
\link{as}

Other makes: 
\code{\link{make_cran}},
\code{\link{make_ego}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_motifs}},
\code{\link{make_play}},
\code{\link{make_random}},
\code{\link{make_read}},
\code{\link{make_stochastic}},
\code{\link{make_write}}
}
\concept{makes}
