% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.lsirm.R
\name{gof}
\alias{gof}
\title{Goodness-of-fit LSIRM}
\usage{
gof(object, chain.idx = 1)
}
\arguments{
\item{object}{Object of class \code{lsirm}.}

\item{chain.idx}{Numeric; Index of MCMC chain. Default is 1.}
}
\value{
\code{gof} returns the boxplot or AUC plot
}
\description{
\link{gof} is goodness-of-fit the latent space of fitted LSIRM.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5),ncol=10,nrow=50)
lsirm_result <- lsirm(data ~ lsirm1pl())
gof(lsirm_result)
}
}
