% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{validate_data}
\alias{validate_data}
\title{Validate data formatting for logitr models}
\usage{
validate_data(
  data,
  outcome,
  obsID,
  pars = NULL,
  scalePar = NULL,
  panelID = NULL
)
}
\arguments{
\item{data}{The data frame to validate}

\item{outcome}{The name of the column that identifies the outcome variable}

\item{obsID}{The name of the column that identifies each observation}

\item{pars}{Optional. The names of parameters to check (for additional validation)}

\item{scalePar}{Optional. The name of the scale parameter column (for WTP models)}

\item{panelID}{Optional. The name of the panel ID column (for panel data)}
}
\value{
An object of class 'logitr_validation' containing validation results
}
\description{
This function checks that data is properly formatted for use with logitr()
and provides detailed diagnostic information about potential issues.
}
\examples{
library(logitr)

# Validate the yogurt dataset
validate_data(yogurt, outcome = "choice", obsID = "obsID")

# Validate with parameters specified
validate_data(yogurt, outcome = "choice", obsID = "obsID",
              pars = c("price", "feat", "brand"))
}
