% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_registrants.R
\name{lob_list_registrants}
\alias{lob_list_registrants}
\title{List Registrants}
\usage{
lob_list_registrants(
  country = NULL,
  dt_updated_after = NULL,
  dt_updated_before = NULL,
  id = NULL,
  ordering = NULL,
  page = NULL,
  page_size = NULL,
  ppb_country = NULL,
  registrant_name = NULL,
  state = NULL,
  clean = TRUE
)
}
\arguments{
\item{country}{Country. Such as "US" or "CA".}

\item{dt_updated_after}{Date Update Range (Before / After): yyyy-mm-dd. Date-time value.}

\item{dt_updated_before}{Date Update Range (Before / After): yyyy-mm-dd. Date-time value.}

\item{id}{ID. Integer value.}

\item{ordering}{Which field to use when ordering the results. String value.}

\item{page}{A page number within the paginated result set. Integer value.}

\item{page_size}{Number of results to return per page. Integer value.}

\item{ppb_country}{PPB Country. Such as "US" or "CA".}

\item{registrant_name}{Registrant Name. String value.}

\item{state}{State. Such as "AL" or "AK".}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or list.}
}
\value{
a \code{tibble} of lobbying registrants
}
\description{
List Registrants
}
\examples{
\dontshow{if (has_lobby_key()) withAutoprint(\{ # examplesIf}
lob_list_registrants(country = 'US')
\dontshow{\}) # examplesIf}
}
