% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_contributions.R
\name{lob_list_contributions}
\alias{lob_list_contributions}
\title{List Contribution Reports}
\usage{
lob_list_contributions(
  contribution_amount_max = NULL,
  contribution_amount_min = NULL,
  contribution_contributor = NULL,
  contribution_date_after = NULL,
  contribution_date_before = NULL,
  contribution_honoree = NULL,
  contribution_payee = NULL,
  contribution_type = NULL,
  filing_dt_posted_after = NULL,
  filing_dt_posted_before = NULL,
  filing_period = NULL,
  filing_type = NULL,
  filing_uuid = NULL,
  filing_year = NULL,
  lobbyist_exclude = NULL,
  lobbyist_id = NULL,
  lobbyist_name = NULL,
  ordering = NULL,
  page = NULL,
  page_size = NULL,
  registrant_id = NULL,
  registrant_name = NULL,
  clean = TRUE
)
}
\arguments{
\item{contribution_amount_max}{Contribution Amount Range. Float value.}

\item{contribution_amount_min}{Contribution Amount Range. Float value.}

\item{contribution_contributor}{Contribution Contributor Name. String value.}

\item{contribution_date_after}{Contribution Date Range (Before / After): yyyy-mm-dd. Date value.}

\item{contribution_date_before}{Contribution Date Range (Before / After): yyyy-mm-dd. Date value.}

\item{contribution_honoree}{Contribution Honoree Name. String value.}

\item{contribution_payee}{Contribution Payee Name. String value.}

\item{contribution_type}{Contribution Type. Such as "feca", "he", "me", "ple", or "pic".}

\item{filing_dt_posted_after}{Filing Date Posted Range (Before / After): yyyy-mm-dd. Date-time value.}

\item{filing_dt_posted_before}{Filing Date Posted Range (Before / After): yyyy-mm-dd. Date-time value.}

\item{filing_period}{Filing Period. Such as "first_quarter", "second_quarter", "third_quarter", "fourth_quarter", "mid_year", or "year_end".}

\item{filing_type}{Filing Type. Such as "RR", "RA", "Q1", "Q1Y", "1T", or "1TY".}

\item{filing_uuid}{filing_uuid. UUID value.}

\item{filing_year}{Filing Year. Such as 2025, 2024, or 2023.}

\item{lobbyist_exclude}{Exclude reports filed by the lobbyists. Boolean value.}

\item{lobbyist_id}{Lobbyist ID. Integer value.}

\item{lobbyist_name}{Lobbyist Name. String value.}

\item{ordering}{Which field to use when ordering the results. String value.}

\item{page}{A page number within the paginated result set. Integer value.}

\item{page_size}{Number of results to return per page. Integer value.}

\item{registrant_id}{Registrant ID. Integer value.}

\item{registrant_name}{Registrant Name. String value.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or list.}
}
\value{
a \code{tibble} of lobbying contributions
}
\description{
List Contribution Reports
}
\examples{
\dontshow{if (has_lobby_key()) withAutoprint(\{ # examplesIf}
lob_list_contributions()
\dontshow{\}) # examplesIf}
}
