% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_trace_UGXX_wrapper}
\alias{compute_trace_UGXX_wrapper}
\title{Calculate Trace of Matrix Product \eqn{\text{trace}(\textbf{X}\textbf{U}\textbf{G}\textbf{X}^{T})}}
\usage{
compute_trace_UGXX_wrapper(
  G,
  A,
  GXX,
  AGAInv,
  nc,
  nca,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{G}{List of G matrices (\eqn{\textbf{G}})}

\item{A}{Constraint matrix (\eqn{\textbf{A}})}

\item{GXX}{List of \eqn{\textbf{G}\textbf{X}^{T}\textbf{X}} products}

\item{AGAInv}{Inverse of \eqn{\textbf{A}^{T}\textbf{G}\textbf{A}}}

\item{nc}{Number of columns}

\item{nca}{Number of constraint columns}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{parallel}{Use parallel processing}

\item{cl}{Cluster object}

\item{chunk_size}{Size of parallel chunks}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remaining chunks}
}
\value{
Trace value
}
\description{
Calculate Trace of Matrix Product \eqn{\text{trace}(\textbf{X}\textbf{U}\textbf{G}\textbf{X}^{T})}
}
\details{
Computes \eqn{\text{trace}(\textbf{X}\textbf{U}\textbf{G}\textbf{X}^{T})} where \eqn{\textbf{U} = \textbf{I} - \textbf{G}\textbf{A}(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}}.
Handles parallel computation by splitting into chunks.
}
\keyword{internal}
