% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mpp.R
\name{simulate_mpp}
\alias{simulate_mpp}
\title{Simulate a realization of a location dependent marked point process}
\usage{
simulate_mpp(
  process = c("self_correcting"),
  process_fit = NULL,
  t_min = 0,
  t_max = 1,
  anchor_point = NULL,
  raster_list = NULL,
  scaled_rasters = FALSE,
  mark_model = NULL,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  competition_radius = 15,
  edge_correction = "none",
  thinning = TRUE,
  seed = NULL,
  mark_mode = NULL,
  size_range = NULL,
  delta = NULL
)
}
\arguments{
\item{process}{type of process used (currently supports \code{"self_correcting"}).}

\item{process_fit}{either (1) a \code{ldmppr_fit} object returned by
\code{\link{estimate_process_parameters}}, or (2) a numeric vector of
length 8 giving the self-correcting process parameters:
\eqn{(\alpha_1,\beta_1,\gamma_1,\alpha_2,\beta_2,\alpha_3,\beta_3,\gamma_3)} (alpha_1, beta_1, gamma_1, alpha_2, beta_2, alpha_3, beta_3, gamma_3).}

\item{t_min}{minimum value for time.}

\item{t_max}{maximum value for time.}

\item{anchor_point}{(optional) vector of (x,y) coordinates of the point to condition on.
If \code{NULL}, inferred from the reference data (largest mark if available) or from
\code{process_fit$data_original} (largest size).}

\item{raster_list}{(optional) list of raster objects used for mark prediction.
Required when \code{mark_mode='mark_model'} unless rasters are stored in \code{mark_model}.}

\item{scaled_rasters}{\code{TRUE} or \code{FALSE} indicating whether rasters are already scaled.
Ignored when \code{mark_mode='time_to_size'}.}

\item{mark_model}{a mark model object used when \code{mark_mode='mark_model'}.
May be an \code{ldmppr_mark_model}, \code{model_fit}, or \code{workflow}.}

\item{xy_bounds}{(optional) vector of bounds as \code{c(a_x, b_x, a_y, b_y)}. If \code{NULL},
bounds are inferred from \code{process_fit} when available.}

\item{include_comp_inds}{\code{TRUE} or \code{FALSE} indicating whether to compute competition indices.}

\item{competition_radius}{positive numeric distance used when \code{include_comp_inds = TRUE}.}

\item{edge_correction}{type of edge correction to apply (\code{"none"} or \code{"toroidal"}).}

\item{thinning}{\code{TRUE} or \code{FALSE} indicating whether to use the thinned simulated values.}

\item{seed}{integer seed for reproducibility.}

\item{mark_mode}{(optional) mark generation mode: \code{"mark_model"} uses
\code{predict()} on a mark model, while \code{"time_to_size"} maps simulated
times back to sizes via \code{delta}. If \code{NULL}, inferred as
\code{"mark_model"} when \code{mark_model} is provided, otherwise
\code{"time_to_size"}.}

\item{size_range}{numeric vector \code{c(smin, smax)} used for \code{mark_mode='time_to_size'}.
If \code{NULL}, inferred from \code{process_fit} when possible.}

\item{delta}{positive scalar used for \code{mark_mode='time_to_size'}.
If \code{NULL}, inferred from \code{process_fit} when possible.}
}
\value{
an object of class \code{"ldmppr_sim"}.
}
\description{
Simulate a realization of a location dependent marked point process
}
\examples{
# Specify the generating parameters of the self-correcting process
generating_parameters <- c(2, 8, .02, 2.5, 3, 1, 2.5, .2)

# Specify an anchor point
M_n <- c(10, 14)

# Load the raster files
raster_paths <- list.files(system.file("extdata", package = "ldmppr"),
  pattern = "\\\\.tif$", full.names = TRUE
)
raster_paths <- raster_paths[!grepl("_med\\\\.tif$", raster_paths)]
rasters <- lapply(raster_paths, terra::rast)

# Scale the rasters
scaled_raster_list <- scale_rasters(rasters)

# Load the example mark model
file_path <- system.file("extdata", "example_mark_model.rds", package = "ldmppr")
mark_model <- load_mark_model(file_path)

# Simulate a realization
example_mpp <- simulate_mpp(
  process = "self_correcting",
  process_fit = generating_parameters,
  t_min = 0,
  t_max = 1,
  anchor_point = M_n,
  raster_list = scaled_raster_list,
  scaled_rasters = TRUE,
  mark_model = mark_model,
  xy_bounds = c(0, 25, 0, 25),
  include_comp_inds = TRUE,
  competition_radius = 10,
  edge_correction = "none",
  thinning = TRUE,
  seed = 90210
)

# Plot the realization and provide a summary
plot(example_mpp, pattern_type = "simulated")
summary(example_mpp)
}
