% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{full_sc_lhood_fast}
\alias{full_sc_lhood_fast}
\title{Evaluate optimized self-correcting log-likelihood}
\usage{
full_sc_lhood_fast(xgrid, ygrid, tgrid, tobs, data, params, bounds)
}
\arguments{
\item{xgrid}{NumericVector of x-grid values.}

\item{ygrid}{NumericVector of y-grid values.}

\item{tgrid}{NumericVector of integration-time grid values.}

\item{tobs}{NumericVector of observed event times.}

\item{data}{NumericMatrix with columns (time, x, y), sorted by nondecreasing time.}

\item{params}{NumericVector of model parameters
(alpha1, beta1, gamma1, alpha2, beta2, alpha3, beta3, gamma3).}

\item{bounds}{NumericVector of integration bounds (bt, bx, by).}
}
\value{
Full self-correcting log-likelihood value.
}
\description{
Optimized implementation used by estimation workflows.
Intended to be numerically consistent with \code{full_sc_lhood()}.
}
\keyword{internal}
