# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' calculates euclidean distance
#'
#' @param x a vector of x values.
#' @param y a vector of y values.
#'
#' @returns the distance between the two vectors.
#' @keywords internal
vec_dist <- function(x, y) {
    .Call('_ldmppr_vec_dist', PACKAGE = 'ldmppr', x, y)
}

#' calculates full product for one grid point
#'
#' @param xgrid a vector of grid values for x.
#' @param ygrid a vector of grid values for y.
#' @param tgrid a t value.
#' @param data a matrix of data.
#' @param params a vector of parameters.
#'
#' @returns returns the product.
#' @keywords internal
full_product <- function(xgrid, ygrid, tgrid, data, params) {
    .Call('_ldmppr_full_product', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, data, params)
}

#' calculates c_theta
#'
#' @param xgrid a vector of grid values for x.
#' @param ygrid a vector of grid values for y.
#' @param tgrid a t value.
#' @param data a matrix of data.
#' @param params a vector of parameters.
#' @param bounds a vector of bounds for time, x, and y.
#'
#' @returns returns the product.
#' @keywords internal
C_theta2_i <- function(xgrid, ygrid, tgrid, data, params, bounds) {
    .Call('_ldmppr_C_theta2_i', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, data, params, bounds)
}

#' calculates sum of values < t
#'
#' @param obs_t a vector of observed t values.
#' @param eval_t a t value.
#' @param y a vector of values.
#'
#' @returns the conditional sum.
#' @keywords internal
conditional_sum <- function(obs_t, eval_t, y) {
    .Call('_ldmppr_conditional_sum', PACKAGE = 'ldmppr', obs_t, eval_t, y)
}

#' calculates sum of values < t
#'
#' @param obs_t a vector of observed t values.
#' @param eval_t a t value.
#' @param y a vector of values.
#'
#' @returns the conditional sum.
#' @keywords internal
conditional_sum_logical <- function(obs_t, eval_t, y) {
    .Call('_ldmppr_conditional_sum_logical', PACKAGE = 'ldmppr', obs_t, eval_t, y)
}

#' calculates euclidean distance between a vector and a matrix
#'
#' @param eval_u a vector of x and y coordinates.
#' @param x_col a vector of x coordinates.
#' @param y_col a vector of y coordinates.
#'
#' @returns a vector of distances between a vector and each row of a matrix.
#' @keywords internal
vec_to_mat_dist <- function(eval_u, x_col, y_col) {
    .Call('_ldmppr_vec_to_mat_dist', PACKAGE = 'ldmppr', eval_u, x_col, y_col)
}

#' calculates distance in one dim
#'
#' @param eval_t a t value.
#' @param obs_t a vector of t values.
#'
#' @returns distance between a single t and the vector of all t values.
#' @keywords internal
dist_one_dim <- function(eval_t, obs_t) {
    .Call('_ldmppr_dist_one_dim', PACKAGE = 'ldmppr', eval_t, obs_t)
}

#' calculates part 1-1 full
#'
#' @param data a matrix of locations and times.
#' @param params a vector of parameters.
#'
#' @returns full likelihood evaluation for part 1.
#' @keywords internal
part_1_1_full <- function(data, params) {
    .Call('_ldmppr_part_1_1_full', PACKAGE = 'ldmppr', data, params)
}

#' calculates part 1-2 full
#'
#' @param data a matrix of locations and times.
#' @param params a vector of parameters.
#'
#' @returns full likelihood evaluation for part 2.
#' @keywords internal
part_1_2_full <- function(data, params) {
    .Call('_ldmppr_part_1_2_full', PACKAGE = 'ldmppr', data, params)
}

#' calculates part 1-3
#'
#' @param xgrid a vector of grid values for x.
#' @param ygrid a vector of grid values for y.
#' @param tgrid a t value.
#' @param data a matrix of times and locations.
#' @param params a vector of parameters.
#' @param bounds a vector of time, x, and y bounds.
#'
#' @returns full likelihood evaluation for part 3.
#' @keywords internal
part_1_3_full <- function(xgrid, ygrid, tgrid, data, params, bounds) {
    .Call('_ldmppr_part_1_3_full', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, data, params, bounds)
}

#' calculates part 1-4
#'
#' @param data a matrix of times and locations.
#' @param params a vector of parameters.
#'
#' @returns full likelihood evaluation for part 4.
#' @keywords internal
part_1_4_full <- function(data, params) {
    .Call('_ldmppr_part_1_4_full', PACKAGE = 'ldmppr', data, params)
}

#' calculates part 1 of the likelihood
#'
#' @param xgrid a vector of grid values for x.
#' @param ygrid a vector of grid values for y.
#' @param tgrid a t value.
#' @param data a matrix of times and locations.
#' @param params a vector of parameters.
#' @param bounds a vector of bounds for time, x, and y.
#'
#' @returns full evaluation of first part of likelihood.
#' @keywords internal
part_1_full <- function(xgrid, ygrid, tgrid, data, params, bounds) {
    .Call('_ldmppr_part_1_full', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, data, params, bounds)
}

#' calculates part 2 of the likelihood
#'
#' @param xgrid a vector of grid values for x.
#' @param ygrid a vector of grid values for y.
#' @param tgrid a vector of grid values for t.
#' @param data a matrix of times and locations.
#' @param params a vector of parameters.
#' @param bounds a vector of bounds for time, x, and y.
#'
#' @returns full evaluation of second part of likelihood.
#' @keywords internal
part_2_full <- function(xgrid, ygrid, tgrid, data, params, bounds) {
    .Call('_ldmppr_part_2_full', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, data, params, bounds)
}

#' Evaluate reference self-correcting log-likelihood
#'
#' Reference implementation used for parity checks and validation.
#' For production estimation, prefer \code{full_sc_lhood_fast()}.
#'
#' @param xgrid NumericVector of x-grid values.
#' @param ygrid NumericVector of y-grid values.
#' @param tgrid NumericVector of integration-time grid values.
#' @param tobs NumericVector of observed event times.
#' @param data NumericMatrix with columns (time, x, y), sorted by nondecreasing time.
#' @param params NumericVector of model parameters
#'   (alpha1, beta1, gamma1, alpha2, beta2, alpha3, beta3, gamma3).
#' @param bounds NumericVector of integration bounds (bt, bx, by).
#'
#' @returns Full self-correcting log-likelihood value.
#' @keywords internal
full_sc_lhood <- function(xgrid, ygrid, tgrid, tobs, data, params, bounds) {
    .Call('_ldmppr_full_sc_lhood', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, tobs, data, params, bounds)
}

#' Evaluate optimized self-correcting log-likelihood
#'
#' Optimized implementation used by estimation workflows.
#' Intended to be numerically consistent with \code{full_sc_lhood()}.
#'
#' @param xgrid NumericVector of x-grid values.
#' @param ygrid NumericVector of y-grid values.
#' @param tgrid NumericVector of integration-time grid values.
#' @param tobs NumericVector of observed event times.
#' @param data NumericMatrix with columns (time, x, y), sorted by nondecreasing time.
#' @param params NumericVector of model parameters
#'   (alpha1, beta1, gamma1, alpha2, beta2, alpha3, beta3, gamma3).
#' @param bounds NumericVector of integration bounds (bt, bx, by).
#'
#' @returns Full self-correcting log-likelihood value.
#' @keywords internal
full_sc_lhood_fast <- function(xgrid, ygrid, tgrid, tobs, data, params, bounds) {
    .Call('_ldmppr_full_sc_lhood_fast', PACKAGE = 'ldmppr', xgrid, ygrid, tgrid, tobs, data, params, bounds)
}

#' calculates spatial interaction
#'
#' @param hist a matrix of points (x,y), n x 2.
#' @param newp a new point vector (x,y), length 2.
#' @param params a vector of parameters (alpha2, beta2).
#'
#' @returns calculated probability of new point.
#' @keywords internal
spat_interaction <- function(hist, newp, params) {
    .Call('_ldmppr_spat_interaction', PACKAGE = 'ldmppr', hist, newp, params)
}

#' Fast spatio-temporal interaction for the self-correcting model
#'
#' Computes $g_i = exp(-alpha3 * sum_\{j<i\} 1[ ||x_i-x_j|| <= beta3 AND (t_i - t_j) >= gamma3 ])$
#' for i = 1..n, with g_0 = exp(0) = 1.
#'
#'
#' @param data NumericMatrix with columns (time, x, y). Assumed sorted by time ascending.
#' @param params NumericVector length 3: (alpha3, beta3, gamma3)
#' @return NumericVector length n of exp(-alpha3 * counts)
#' @keywords internal
interaction_st_fast <- function(data, params) {
    .Call('_ldmppr_interaction_st_fast', PACKAGE = 'ldmppr', data, params)
}

#' calculates acceptance for thinning mechanism during simulation
#'
#' @param data NumericMatrix with columns (time, x, y). Assumed sorted by time ascending.
#' @param params NumericVector length 3: (alpha3, beta3, gamma3
#'
#' @return LogicalVector length n of whether to keep each point (true) or thin it (false).
thin_st_fast <- function(data, params) {
    .Call('_ldmppr_thin_st_fast', PACKAGE = 'ldmppr', data, params)
}

#' calculates temporal likelihood
#'
#' @param params a vector of parameters (alpha_1, beta_1, gamma_1).
#' @param eval_t a t value.
#' @param obs_t a vector of t values.
#'
#' @returns evaluation of full temporal likelihood.
#' @keywords internal
temporal_sc <- function(params, eval_t, obs_t) {
    .Call('_ldmppr_temporal_sc', PACKAGE = 'ldmppr', params, eval_t, obs_t)
}

#' Simulate the temporal component of the self-correcting model
#'
#' @param Tmin minimum time value.
#' @param Tmax maximum time value.
#' @param params a vector of parameters (alpha_1, beta_1, gamma_1).
#'
#' @return a vector of thinned and unthinned temporal samples.
#' @keywords internal
sim_temporal_sc <- function(Tmin = 0, Tmax = 1, params = as.numeric( c(0, 0, 0))) {
    .Call('_ldmppr_sim_temporal_sc', PACKAGE = 'ldmppr', Tmin, Tmax, params)
}

#' Simulate the spatial component of the self-correcting model (faster)
#'
#' @param M_n a vector of (x,y)-coordinates for anchor/first point.
#' @param params a vector of parameters (alpha_2, beta_2).
#' @param nsim_t number of points to simulate.
#' @param xy_bounds vector: (ax, bx, ay, by).
#'
#' @return a matrix nsim_t x 2 of point locations (x,y).
#' @keywords internal
sim_spatial_sc <- function(M_n, params, nsim_t, xy_bounds) {
    .Call('_ldmppr_sim_spatial_sc', PACKAGE = 'ldmppr', M_n, params, nsim_t, xy_bounds)
}

