% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rboTopics.R
\name{rboTopics}
\alias{rboTopics}
\title{Pairwise RBO Similarities}
\usage{
rboTopics(topics, k, p, progress = TRUE, pm.backend, ncpus)
}
\arguments{
\item{topics}{[\code{named matrix}]\cr
The counts of vocabularies/words (row wise) in topics (column wise).}

\item{k}{[\code{integer(1)}]\cr
Maximum depth for evaluation. Words down to this rank are considered for the calculation of similarities.}

\item{p}{[0,1]\cr
Weighting parameter. Lower values emphasizes top ranked words while values
that go towards 1 correspond to equal weights for each evaluation depth.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.
If \code{pm.backend} is set, parallelization is done and no progress bar will be shown.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passed,
default is determined by \code{\link[parallelly]{availableCores}}.}
}
\value{
[\code{named list}] with entries
\describe{
  \item{\code{sims}}{[\code{lower triangular named matrix}] with all pairwise
  similarities of the given topics.}
  \item{\code{wordslimit}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{wordsconsidered}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{param}}{[\code{named list}] with parameter
  \code{type} [\code{character(1)}] \code{= "RBO Similarity"},
  \code{k} [\code{integer(1)}] and \code{p} [0,1]. See above for explanation.}
}
}
\description{
Calculates the similarity of all pairwise topic combinations using the
rank-biased overlap (RBO) Similarity.
}
\details{
The RBO Similarity for two topics \eqn{\bm z_{i}} and \eqn{\bm z_{j}}
is calculated by
\deqn{RBO(\bm z_{i}, \bm z_{j} \mid k, p) = 2p^k\frac{\left|Z_{i}^{(k)} \cap Z_{j}^{(k)}\right|}{\left|Z_{i}^{(k)}\right| + \left|Z_{j}^{(k)}\right|} + \frac{1-p}{p} \sum_{d=1}^k 2 p^d\frac{\left|Z_{i}^{(d)} \cap Z_{j}^{(d)}\right|}{\left|Z_{i}^{(d)}\right| + \left|Z_{j}^{(d)}\right|}}
with \eqn{Z_{i}^{(d)}} is the vocabulary set of topic \eqn{\bm z_{i}} down to
rank \eqn{d}. Ties in ranks are resolved by taking the minimum.

The value \code{wordsconsidered} describes the number of words per topic
ranked at rank \eqn{k} or above.
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
rbo = rboTopics(topics, k = 12, p = 0.9)
rbo

sim = getSimilarity(rbo)
dim(sim)

}
\references{
Webber, William, Alistair Moffat and Justin Zobel (2010).
"A similarity measure for indefinite rankings".
In: \emph{ACM Transations on Information Systems} 28(4), p.20:1–-20:38,
\doi{10.1145/1852102.1852106}.
}
\seealso{
Other TopicSimilarity functions: 
\code{\link{cosineTopics}()},
\code{\link{dendTopics}()},
\code{\link{getSimilarity}()},
\code{\link{jaccardTopics}()},
\code{\link{jsTopics}()}
}
\concept{TopicSimilarity functions}
