% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{process_utils}
\alias{process_utils}
\alias{application_preprocess_inputs}
\alias{application_decode_predictions}
\title{Preprocessing and postprocessing utilities}
\usage{
application_preprocess_inputs(model, x, ..., data_format = NULL)

application_decode_predictions(model, preds, top = 5L, ...)
}
\arguments{
\item{model}{A Keras model initialized using any \code{application_} function.}

\item{x}{A batch of inputs to the model. If \code{x} is missing, then the \code{preprocess_input} function appropriate for \code{model} is returned.}

\item{...}{Additional arguments passed to the preprocessing or decoding function.}

\item{data_format}{Optional data format of the image tensor/array.
\code{NULL} means the global setting
\code{config_image_data_format()} is used
(unless you changed it, it uses \code{"channels_last"}).
Defaults to \code{NULL}.}

\item{preds}{A batch of outputs from the model.}

\item{top}{The number of top predictions to return.}
}
\value{
\itemize{
\item A list of decoded predictions in case of \code{application_decode_predictions()}.
\item A batch of preprocessed inputs in case of \code{application_preprocess_inputs()}.
}
}
\description{
These functions are used to preprocess and postprocess
inputs and outputs of Keras applications.
}
\section{Functions}{
\itemize{
\item \code{application_preprocess_inputs()}: Pre-process inputs to be used in the model

\item \code{application_decode_predictions()}: Decode predictions from the model

}}
\examples{
\dontrun{
model <- application_convnext_tiny()

inputs <- random_normal(c(32, 224, 224, 3))
processed_inputs <- application_preprocess_inputs(model, inputs)

preds <- random_normal(c(32, 1000))
decoded_preds <- application_decode_predictions(model, preds)

}
}
