% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseBarcodedReads.R
\name{countBarcodedReads}
\alias{countBarcodedReads}
\alias{countBarcodedReadsFromContig}
\title{Get read counts from barcoded reads}
\usage{
countBarcodedReads(
  TapestriExperiment,
  bam.file,
  barcode.lookup,
  probe,
  return.table = FALSE,
  max.mismatch = 2,
  with.indels = FALSE,
  ...
)

countBarcodedReadsFromContig(
  bam.file,
  barcode.lookup,
  contig,
  cell.barcode.tag = "RG",
  max.mismatch = 2,
  with.indels = FALSE
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{bam.file}{File path of BAM file. \code{.bai} BAM index file must be in the same location (can be generated using \code{\link[Rsamtools:scanBam]{Rsamtools::indexBam()}}).}

\item{barcode.lookup}{\code{data.frame} where the first column is the barcode identifier/name and the second column is the DNA sequence. Headers are ignored.}

\item{probe}{Character, either "gRNA" or "barcode" to parse counts from \code{grnaCounts} or \code{barcodeCounts} \code{altExp} slots, respectively.}

\item{return.table}{Logical, if \code{TRUE}, returns table of read counts per barcode. If \code{FALSE}, returns \code{TapestriExperiment.} Default \code{FALSE}.}

\item{max.mismatch}{Numeric, the maximum and minimum number of mismatching letters allowed. Default 2.}

\item{with.indels}{If \code{TRUE}, then indels are allowed. Default \code{FALSE}.}

\item{...}{Arguments to pass on to \code{countBarcodedReadsFromContig()}.}

\item{contig}{Character, contig or chromosome name to search for barcodes in. Can be a vector of more than one contig to expand search space.}

\item{cell.barcode.tag}{Character of length 2, indicates cell barcode field in BAM, specified by Tapestri pipeline (currently "RG"). Default "RG".}
}
\value{
\code{TapestriExperiment} with barcoded read counts added to \code{colData}.

A data.frame of read counts for each specified barcode.
}
\description{
\code{countBarcodedReads()} and \code{countBarcodedReadsFromContig()} match exogenous DNA barcode sequences to their associated
cell barcodes and saves them to the \code{colData} (cell barcode metadata) of \code{TapestriExperiment}.
\code{countBarcodedReads()} is a shortcut for \code{countBarcodedReadsFromContig()}, allowing the user to specify 'gRNA' or 'barcode'
to use the \code{grnaCounts} or \code{barcodeCounts} \code{altExp} slots.
The entries in the \code{barcode.lookup} table do not have to be present in the sample,
allowing users to keep one master table/file of available barcode sequences for use in all experiments.
The \code{Rsamtools} and \code{Biostrings} packages must be installed to use these functions.
}
\examples{
\dontrun{
counts <- countBarcodedReads(
  TapestriExperiment,
  bam.file, barcode.lookup, "gRNA"
)
}
\dontrun{
counts <- countBarcodedReadsFromContig(bam.file, barcode.lookup, "virus_ref2")
}
}
\seealso{
\code{\link[Rsamtools:scanBam]{Rsamtools::indexBam()}}

\code{\link[Biostrings:matchPattern]{Biostrings::matchPattern()}}
}
\concept{barcoded reads}
