% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_multnom.R
\name{multnom_pred}
\alias{multnom_pred}
\title{multnom_pred}
\usage{
multnom_pred(conj.param, outcome, parms = list(), pred.cred = 0.95)
}
\arguments{
\item{conj.param}{List or data.frame: The parameters of the conjugated distributions of the linear predictor.}

\item{outcome}{Vector or matrix: The observed values at the current time. The value passed is used to compute N.}

\item{parms}{List (optional): A list of extra parameters for the model. Not used in this function.}

\item{pred.cred}{Numeric: the desired credibility for the credibility interval.}
}
\value{
A list containing the following values:
\itemize{
   \item pred vector/matrix: the mean of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item var.pred vector/matrix: the variance of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icl.pred vector/matrix: the percentile of 100*((1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icu.pred vector/matrix: the percentile of 100*(1-(1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item log.like vector: the The log likelihood for the outcome given the conjugated parameters.
}
}
\description{
Calculate the values for the predictive distribution given the values of the parameter of the conjugated distribution of the linear predictor.
The data is assumed to have Multinomial distribution with known number of trial N and the probability vector having distribution Dirichlet with parameters alpha_i.
In this scenario, the marginal distribution of the data is Dirichlet-Multinomial with parameters N and alpha_i.
}
\seealso{
Other auxiliary functions for a Multinomial outcome: 
\code{\link{convert_Multinom_Normal}()},
\code{\link{convert_Normal_Multinom}()},
\code{\link{update_Multinom}()}
}
\concept{auxiliary functions for a Multinomial outcome}
\keyword{internal}
