% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_maxlev.R
\name{a_maxlev}
\alias{a_maxlev}
\title{Calculate Count and Percentage of the Maximum Level of an Ordered Factor per
Subject.}
\usage{
a_maxlev(
  df,
  labelstr = NULL,
  .var,
  .spl_context,
  id = "USUBJID",
  .alt_df_full = NULL,
  any_level = FALSE,
  any_level_exclude = "Missing",
  ...
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{id}{(\code{string})\cr subject variable name.}

\item{.alt_df_full}{(\code{dataframe})\cr A dataset used to compute the
denominator for proportions. This is required when the same subject appears
multiple times in the dataset due to treatment sequences.
\code{colnames(.alt_df_full)} must be a superset of \code{id}.
This argument gets populated by the rtables split machinery
(see \link[rtables:additional_fun_params]{rtables::additional_fun_params}).}

\item{any_level}{(\code{flag})\cr
Should be set to \code{TRUE} when the function is used as a \code{cfun}.}

\item{any_level_exclude}{(\code{character})\cr
Applicable only when \code{any_level = TRUE}. Specifies levels of \code{df[[.var]]}
to exclude from the statistic (default = "Missing").}

\item{...}{additional arguments for the lower level functions.}
}
\value{
A \code{RowsVerticalSection} object.
}
\description{
A formatted analysis function used as an \code{afun} in
\link[rtables]{analyze} and as a \code{cfun} in \link[rtables]{summarize_row_groups}.

It computes count and proportion statistics for the maximum level of an
ordered factor, \code{df[[.var]]}, for each unique subject in \code{df[[id]]}.
Specifically, for each subject, the function identifies the highest level
of \code{df[[.var]]}, producing one value per subject.
Then, if \code{any_level = TRUE}, the function reports the total number of
maximum values, excluding those specified in \code{any_level_exclude}.
Otherwise, it tabulates the frequency of each maximum level across all
subjects.

This function is particularly useful for identifying the maximum severity of
adverse events in a treatment sequence, where the most severe event
experienced by a subject is used for reporting.
}
\details{
For each unique subject, only the maximum level of the ordered factor
\code{df[[.var]]} is included in the final count and percentage statistics.
}
\note{
The denominator for proportions is computed using the \code{denom_df}
argument. This serves as a temporary workaround until the next version of
\code{rtables} is released, which will support \code{.alt_count_df} for use in
\code{afun}/\code{cfun}.
}
\examples{
treatments <- factor(c("a", "b", "c"))
ae_severities <- c("Missing", "Mild", "Moderate", "Severe")
ae_severities <- ordered(ae_severities, levels = ae_severities)
my_adae <- data.frame(
  ID = c(1, 1, 1, 2, 2, 3, 3, 3, 3, 4),
  TRT = factor(c("a", "b", "b", "b", "c", "c", "a", "c", "b", "b")),
  AESEV = ae_severities[c(4L, 1L, 2L, 1L, 2L, 1L, 2L, 3L, 1L, 2L)]
)
my_adsl <- data.frame(
  ID = rep(1:5, each = 3),
  TRT = factor(rep(c("a", "b", "c"), times = 5))
)

aesevall_spf <- make_combo_splitfun(
  nm = "AESEV_ALL",
  label = "Any AE",
  levels = NULL,
)

lyt <- basic_table() |>
  split_cols_by("TRT") |>
  add_overall_col("Total") |>
  split_rows_by("AESEV", split_fun = aesevall_spf) |>
  summarize_row_groups(
    "AESEV",
    cfun = a_maxlev,
    extra_args = list(id = "ID", any_level = TRUE)
  ) |>
  analyze(
    "AESEV",
    afun = a_maxlev,
    extra_args = list(id = "ID")
  )
build_table(lyt, my_adae, alt_counts_df = my_adsl)
}
